"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleMetricDetectorsSummary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../../../../../contexts/kibana");
var _job_creator_context = require("../../../job_creator_context");
var _anomaly_chart = require("../../../charts/anomaly_chart");
var _settings = require("../../../charts/common/settings");
var _toast_notification_service = require("../../../../../../../services/toast_notification_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/single_metric_view/metric_selection_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DTR_IDX = 0;
const SingleMetricDetectorsSummary = () => {
  const uiSettings = (0, _kibana.useUiSettings)();
  const {
    jobCreator: jc,
    chartLoader,
    resultsLoader,
    chartInterval
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const [lineChartsData, setLineChartData] = (0, _react.useState)({});
  const [loadingData, setLoadingData] = (0, _react.useState)(false);
  const [modelData, setModelData] = (0, _react.useState)([]);
  const [anomalyData, setAnomalyData] = (0, _react.useState)([]);
  function setResultsWrapper(results) {
    const model = results.model[DTR_IDX];
    if (model !== undefined) {
      setModelData(model);
    }
    const anomalies = results.anomalies[DTR_IDX];
    if (anomalies !== undefined) {
      setAnomalyData(anomalies);
    }
  }
  (0, _react.useEffect)(() => {
    // subscribe to progress and results
    const subscription = resultsLoader.subscribeToResults(setResultsWrapper);
    loadChart();
    return () => {
      subscription.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [resultsLoader]);
  async function loadChart() {
    if (jobCreator.aggFieldPair !== null) {
      setLoadingData(true);
      try {
        const cs = (0, _settings.getChartSettings)(uiSettings, jobCreator, chartInterval);
        const resp = await chartLoader.loadLineCharts(jobCreator.start, jobCreator.end, [jobCreator.aggFieldPair], null, null, cs.intervalMs, jobCreator.runtimeMappings, jobCreator.datafeedConfig.indices_options);
        if (resp[DTR_IDX] !== undefined) {
          setLineChartData(resp);
        }
      } catch (error) {
        toastNotificationService.displayErrorToast(error);
        setLineChartData({});
      }
      setLoadingData(false);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, (lineChartsData[DTR_IDX] !== undefined || loadingData === true) && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_anomaly_chart.AnomalyChart, {
    chartType: _anomaly_chart.CHART_TYPE.LINE,
    chartData: lineChartsData[DTR_IDX],
    modelData: modelData,
    anomalyData: anomalyData,
    height: "300px",
    width: "100%",
    loading: loadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  })));
};
exports.SingleMetricDetectorsSummary = SingleMetricDetectorsSummary;