"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSeverityLegendControlStyles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSeverityLegendControlStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    severityControl: (0, _react.css)({
      height: '100%',
      padding: `0 ${euiTheme.size.s}`
    }),
    severityButton: (0, _react.css)({
      padding: `${euiTheme.size.xs}`,
      '&:hover': {
        backgroundColor: 'transparent'
      },
      '&:focus': {
        backgroundColor: 'transparent'
      }
    }),
    severityText: isSelected => (0, _react.css)({
      color: isSelected ? euiTheme.colors.textParagraph : euiTheme.colors.textDisabled
    })
  };
};
exports.useSeverityLegendControlStyles = useSeverityLegendControlStyles;