"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimerangeBarStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimerangeBarStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    ganttBar: (0, _react.css)({
      backgroundColor: euiTheme.colors.vis.euiColorVis2,
      height: euiTheme.size.m,
      borderRadius: '2px'
    }),
    ganttBarBackEdge: (0, _react.css)({
      height: euiTheme.size.base,
      borderLeft: `1px solid ${euiTheme.colors.borderBasePlain}`,
      borderRight: `1px solid ${euiTheme.colors.borderBasePlain}`,
      marginBottom: '-14px',
      paddingTop: euiTheme.size.s
    }),
    ganttBarDashed: (0, _react.css)({
      height: '1px',
      borderTop: `1px dashed ${euiTheme.colors.borderBasePlain}`
    }),
    ganttBarRunning: (0, _react.css)({
      backgroundImage: `linear-gradient(45deg,
        rgba(255, 255, 255, .15) 25%,
        transparent 25%,
        transparent 50%,
        rgba(255, 255, 255, .15) 50%,
        rgba(255, 255, 255, .15) 75%,
        transparent 75%,
        transparent)`,
      backgroundSize: `${euiTheme.size.xxl} ${euiTheme.size.xxl}`,
      animation: 'progress-bar-stripes 2s linear infinite'
    })
  };
};
exports.useTimerangeBarStyles = useTimerangeBarStyles;