"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidCustomUrls = isValidCustomUrls;
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _custom_url_utils = require("../../util/custom_url_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isValidCustomUrls(customUrls) {
  if (customUrls === undefined || customUrls.length === 0) {
    return true;
  }

  // Check all the custom URLs have unique labels and the time range is valid.
  const isInvalidItem = customUrls.some((customUrl, index) => {
    // Validate the label.
    const label = customUrl.url_name;
    const otherUrls = [...customUrls];
    otherUrls.splice(index, 1); // Don't compare label with itself.
    let itemValid = (0, _custom_url_utils.isValidLabel)(label, otherUrls);
    if (itemValid === true && (0, _mlAnomalyUtils.isMlKibanaUrlConfigWithTimeRange)(customUrl)) {
      // Validate the time range.
      const timeRange = customUrl.time_range;
      itemValid = (0, _custom_url_utils.isValidTimeRange)(timeRange);
    }
    return !itemValid;
  });
  return !isInvalidItem;
}