"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRelevantAnomalyFields = getRelevantAnomalyFields;
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _filter_field_constants = require("@kbn/ml-anomaly-utils/alerting/filter_field_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get relevant fields for filtering anomalies based on job configuration and result type.
 * These fields will be used to restrict autocomplete suggestions in the KQL filter.
 */
function getRelevantAnomalyFields(jobConfigs, resultType) {
  // For bucket result type, filtering is disabled
  if (resultType === _mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.BUCKET) {
    return [];
  }
  if (resultType === _mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.INFLUENCER) {
    return [..._filter_field_constants.INFLUENCER_FILTER_FIELDS];
  }

  // Determine if this is a pure population job (single detector with over_field)
  const isPurePopulationJob = jobConfigs.length > 0 && jobConfigs.every(job => {
    var _job$analysis_config$, _job$analysis_config;
    const detectors = (_job$analysis_config$ = (_job$analysis_config = job.analysis_config) === null || _job$analysis_config === void 0 ? void 0 : _job$analysis_config.detectors) !== null && _job$analysis_config$ !== void 0 ? _job$analysis_config$ : [];
    return detectors.length === 1 && detectors[0].over_field_name;
  });

  // Check if any job has influencers configured
  const hasInfluencers = jobConfigs.length > 0 && jobConfigs.some(job => {
    var _job$analysis_config$2, _job$analysis_config2;
    const influencers = (_job$analysis_config$2 = (_job$analysis_config2 = job.analysis_config) === null || _job$analysis_config2 === void 0 ? void 0 : _job$analysis_config2.influencers) !== null && _job$analysis_config$2 !== void 0 ? _job$analysis_config$2 : [];
    return influencers.length > 0;
  });

  // Add actual/typical fields based on job type
  const recordFields = [..._filter_field_constants.BASE_RECORD_FILTER_FIELDS, ...(hasInfluencers ? _filter_field_constants.RECORD_INFLUENCER_FIELDS : []), ...(isPurePopulationJob ? _filter_field_constants.NESTED_ACTUAL_TYPICAL_FIELDS : _filter_field_constants.TOP_LEVEL_ACTUAL_TYPICAL_FIELDS)];
  const detectorFields = new Set();
  if (jobConfigs.length > 0) {
    jobConfigs.forEach(job => {
      var _job$analysis_config$3, _job$analysis_config3;
      const detectors = (_job$analysis_config$3 = (_job$analysis_config3 = job.analysis_config) === null || _job$analysis_config3 === void 0 ? void 0 : _job$analysis_config3.detectors) !== null && _job$analysis_config$3 !== void 0 ? _job$analysis_config$3 : [];
      detectors.forEach(detector => {
        if (detector.partition_field_name) {
          detectorFields.add(_filter_field_constants.DETECTOR_FILTER_FIELDS.PARTITION_FIELD_NAME);
          detectorFields.add(_filter_field_constants.DETECTOR_FILTER_FIELDS.PARTITION_FIELD_VALUE);
          detectorFields.add(detector.partition_field_name);
        }
        if (detector.by_field_name) {
          detectorFields.add(_filter_field_constants.DETECTOR_FILTER_FIELDS.BY_FIELD_NAME);
          detectorFields.add(_filter_field_constants.DETECTOR_FILTER_FIELDS.BY_FIELD_VALUE);
          detectorFields.add(detector.by_field_name);
        }
        if (detector.over_field_name) {
          detectorFields.add(_filter_field_constants.DETECTOR_FILTER_FIELDS.OVER_FIELD_NAME);
          detectorFields.add(_filter_field_constants.DETECTOR_FILTER_FIELDS.OVER_FIELD_VALUE);
          detectorFields.add(detector.over_field_name);
        }
      });
    });
  }
  return [...recordFields, ...Array.from(detectorFields)];
}