"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMlSeverityColorRampValue = void 0;
var _anomaly_threshold = require("./anomaly_threshold");
var _use_severity_color = require("./use_severity_color");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a theme-aware color ramp for ML severity scores.
 * @param euiTheme The EUI theme object.
 * @returns An array of ColorRampStop objects.
 */
const getMlSeverityColorRampValue = euiTheme => [{
  stop: _anomaly_threshold.ML_ANOMALY_THRESHOLD.LOW,
  color: (0, _use_severity_color.getThemeResolvedSeverityColor)(_anomaly_threshold.ML_ANOMALY_THRESHOLD.LOW, euiTheme)
}, {
  stop: _anomaly_threshold.ML_ANOMALY_THRESHOLD.MINOR,
  color: (0, _use_severity_color.getThemeResolvedSeverityColor)(_anomaly_threshold.ML_ANOMALY_THRESHOLD.MINOR, euiTheme)
}, {
  stop: _anomaly_threshold.ML_ANOMALY_THRESHOLD.MAJOR,
  color: (0, _use_severity_color.getThemeResolvedSeverityColor)(_anomaly_threshold.ML_ANOMALY_THRESHOLD.MAJOR, euiTheme)
}, {
  stop: _anomaly_threshold.ML_ANOMALY_THRESHOLD.CRITICAL,
  color: (0, _use_severity_color.getThemeResolvedSeverityColor)(_anomaly_threshold.ML_ANOMALY_THRESHOLD.CRITICAL, euiTheme)
}];
exports.getMlSeverityColorRampValue = getMlSeverityColorRampValue;