"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateCustomFilterFields = validateCustomFilterFields;
var _i18n = require("@kbn/i18n");
var _get_kql_fields = require("@kbn/es-query/src/kuery/utils/get_kql_fields");
var _constants = require("../constants");
var _filter_field_constants = require("./filter_field_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Validates that fields in a KQL filter are not in the disallowlist for the given result type.
 */
function validateCustomFilterFields(kqlQueryString, resultType) {
  // Check if filtering is allowed for this result type
  if (resultType === _constants.ML_ANOMALY_RESULT_TYPE.BUCKET) {
    return _i18n.i18n.translate('xpack.ml.anomalyDetection.customFilter.bucketNotSupported', {
      defaultMessage: 'Custom filters are not supported for bucket result type'
    });
  }

  // Extract field names from the KQL
  let fieldNames;
  try {
    fieldNames = (0, _get_kql_fields.getKqlFieldNamesFromExpression)(kqlQueryString);
  } catch (e) {
    // Syntax error, caller should handle KQL syntax validation separately
    return undefined;
  }

  // Validate against disallowlist
  const disallowedFields = [..._filter_field_constants.DISALLOWED_FILTER_FIELDS];
  const invalidFields = fieldNames.filter(field => disallowedFields.includes(field));
  if (invalidFields.length > 0) {
    return _i18n.i18n.translate('xpack.ml.anomalyDetection.customFilter.disallowedFields', {
      defaultMessage: 'The following fields are not allowed for filtering: {fields}',
      values: {
        fields: invalidFields.join(', ')
      }
    });
  }
  return undefined;
}