"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _metrics_client = require("./lib/metrics_client");
var _create_lazy_container_metrics_table = require("./components/infrastructure_node_metrics_tables/container/create_lazy_container_metrics_table");
var _create_lazy_host_metrics_table = require("./components/infrastructure_node_metrics_tables/host/create_lazy_host_metrics_table");
var _create_lazy_pod_metrics_table = require("./components/infrastructure_node_metrics_tables/pod/create_lazy_pod_metrics_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Plugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = context.logger.get();
  }
  setup(core) {
    const metricsClient = new _metrics_client.MetricsDataClient(core.http);
    return {
      metricsClient
    };
  }
  start(core) {
    const metricsClient = new _metrics_client.MetricsDataClient(core.http);
    return {
      metricsClient,
      ContainerMetricsTable: (0, _create_lazy_container_metrics_table.createLazyContainerMetricsTable)(core, metricsClient),
      HostMetricsTable: (0, _create_lazy_host_metrics_table.createLazyHostMetricsTable)(core, metricsClient),
      PodMetricsTable: (0, _create_lazy_pod_metrics_table.createLazyPodMetricsTable)(core, metricsClient)
    };
  }
  stop() {}
}
exports.Plugin = Plugin;