"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PodMetricsTable = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _shared = require("../shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/metrics_data_access/public/components/infrastructure_node_metrics_tables/pod/pod_metrics_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PodMetricsTable = props => {
  const {
    data,
    isLoading,
    setCurrentPageIndex,
    setSortState,
    sortState,
    timerange
  } = props;
  const columns = (0, _react.useMemo)(() => podNodeColumns(timerange), [timerange]);
  const sorting = {
    enableAllColumns: true,
    sort: sortState
  };
  const onTableSortChange = ({
    sort = {
      direction: 'desc',
      field: 'averageCpuUsagePercent'
    }
  }) => {
    setSortState(sort);
    setCurrentPageIndex(0);
  };
  if (data.state === 'error') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data.errors.map(error => /*#__PURE__*/_react.default.createElement(_shared.MetricsTableErrorContent, {
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    })));
  } else if (isLoading && data.state !== 'data') {
    return /*#__PURE__*/_react.default.createElement(_shared.MetricsTableLoadingContent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 12
      }
    });
  } else if (data.state === 'no-indices') {
    return /*#__PURE__*/_react.default.createElement(_shared.MetricsTableNoIndicesContent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 12
      }
    });
  } else if (data.state === 'empty-indices') {
    return /*#__PURE__*/_react.default.createElement(_shared.MetricsTableEmptyIndicesContent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 12
      }
    });
  } else if (data.state === 'data') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      tableCaption: _i18n.i18n.translate('xpack.metricsData.metricsTable.pod.tableCaption', {
        defaultMessage: 'Infrastructure metrics for pods'
      }),
      items: data.rows,
      columns: columns,
      sorting: sorting,
      onChange: onTableSortChange,
      loading: isLoading,
      noItemsMessage: /*#__PURE__*/_react.default.createElement(_shared.MetricsTableLoadingContent, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 27
        }
      }),
      "data-test-subj": "podMetricsTable",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      alignItems: "center",
      responsive: false,
      wrap: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_shared.StepwisePagination, {
      ariaLabel: _i18n.i18n.translate('xpack.metricsData.metricsTable.pod.paginationAriaLabel', {
        defaultMessage: 'Pod metrics pagination'
      }),
      pageCount: data.pageCount,
      currentPageIndex: data.currentPageIndex,
      setCurrentPageIndex: setCurrentPageIndex,
      "data-test-subj": "podMetricsTablePagination",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 13
      }
    }))));
  } else {
    return null;
  }
};
exports.PodMetricsTable = PodMetricsTable;
function podNodeColumns(timerange) {
  return [{
    name: _i18n.i18n.translate('xpack.metricsData.metricsTable.pod.nameColumnHeader', {
      defaultMessage: 'Name'
    }),
    field: 'name',
    truncateText: true,
    textOnly: true,
    render: (_, {
      id,
      name
    }) => {
      return /*#__PURE__*/_react.default.createElement(_shared.MetricsNodeDetailsLink, {
        id: id,
        label: name,
        nodeType: 'pod',
        timerange: timerange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 11
        }
      });
    }
  }, {
    name: _i18n.i18n.translate('xpack.metricsData.metricsTable.pod.averageCpuUsagePercentColumnHeader', {
      defaultMessage: 'CPU usage (avg.)'
    }),
    field: 'averageCpuUsagePercent',
    align: 'right',
    render: averageCpuUsagePercent => /*#__PURE__*/_react.default.createElement(_shared.NumberCell, {
      value: averageCpuUsagePercent,
      unit: "%",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 9
      }
    })
  }, {
    name: _i18n.i18n.translate('xpack.metricsData.metricsTable.pod.averageMemoryUsageMegabytesColumnHeader', {
      defaultMessage: 'Memory usage (avg.)'
    }),
    field: 'averageMemoryUsageMegabytes',
    align: 'right',
    render: averageMemoryUsageMegabytes => /*#__PURE__*/_react.default.createElement(_shared.NumberCell, {
      value: averageMemoryUsageMegabytes,
      unit: " MB",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 9
      }
    })
  }];
}