"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricsExporterConfigSchema = exports.metricsConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const metricsCommonExporterConfigSchema = _configSchema.schema.object({
  exportInterval: _configSchema.schema.maybe(_configSchema.schema.duration()),
  exportTimeout: _configSchema.schema.maybe(_configSchema.schema.duration()),
  temporalityPreference: _configSchema.schema.oneOf([_configSchema.schema.literal('cumulative'), _configSchema.schema.literal('delta')], {
    defaultValue: 'delta'
  })
});
const metricsExporterConfigSchema = exports.metricsExporterConfigSchema = _configSchema.schema.oneOf([
// gRPC OTLP Exporter
_configSchema.schema.object({
  grpc: metricsCommonExporterConfigSchema.extends({
    url: _configSchema.schema.string(),
    headers: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string()))
  })
}),
// HTTP OTLP Exporter
_configSchema.schema.object({
  http: metricsCommonExporterConfigSchema.extends({
    url: _configSchema.schema.string(),
    headers: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string()))
  })
})]);

/**
 * The metrics config schema that is exposed by the Telemetry plugin.
 */
const metricsConfigSchema = exports.metricsConfigSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  interval: _configSchema.schema.duration({
    defaultValue: '10s'
  }),
  timeout: _configSchema.schema.maybe(_configSchema.schema.duration()),
  exporters: _configSchema.schema.oneOf([metricsExporterConfigSchema, _configSchema.schema.arrayOf(metricsExporterConfigSchema)], {
    defaultValue: []
  })
});