"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.savedObjectToItem = savedObjectToItem;
var _transform_map_attributes_out = require("../../../../common/content_management/transform_map_attributes_out");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function savedObjectToItem(savedObject, partial) {
  const {
    references,
    attributes,
    ...rest
  } = savedObject;
  return {
    ...rest,
    attributes: (0, _transform_map_attributes_out.transformMapAttributesOut)(attributes, targetName => {
      return references ? references.find(({
        name
      }) => name === targetName) : undefined;
    }),
    references: (references !== null && references !== void 0 ? references : []).filter(({
      type
    }) => type === 'tag')
  };
}