"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrawFeatureControl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var jsts = _interopRequireWildcard(require("jsts"));
var _kibana_services = require("../../../../kibana_services");
var _draw_control = require("../draw_control");
var _constants = require("../../../../../common/constants");
var _mb_filter_expressions = require("../../../../classes/util/mb_filter_expressions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/mb_map/draw_control/draw_feature_control/draw_feature_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error
// @ts-expect-error
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const geoJSONReader = new jsts.io.GeoJSONReader();
class DrawFeatureControl extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_onDraw", async (e, mbDrawControl) => {
      try {
        const geometries = [];
        e.features.forEach(feature => {
          const {
            geometry
          } = geoJSONReader.read(feature);
          if (!geometry.isSimple() || !geometry.isValid()) {
            throw new Error(_i18n.i18n.translate('xpack.maps.drawFeatureControl.invalidGeometry', {
              defaultMessage: `Invalid geometry detected`
            }));
          }
          if ('coordinates' in feature.geometry) {
            // @ts-ignore /* Single position array only used if point geometry */
            const featureGeom = this.props.drawMode === _constants.DRAW_MODE.DRAW_POINTS ? feature.geometry.coordinates : feature.geometry;
            geometries.push(featureGeom);
          }
        });
        if (geometries.length) {
          this.props.addNewFeatureToIndex(geometries);
        }
      } catch (error) {
        (0, _kibana_services.getToasts)().addWarning(_i18n.i18n.translate('xpack.maps.drawFeatureControl.unableToCreateFeature', {
          defaultMessage: `Unable to create feature, error: ''{errorMsg}''.`,
          values: {
            errorMsg: error.message
          }
        }));
      } finally {
        try {
          mbDrawControl.deleteAll();
        } catch (_e) {
          // Fail silently. Always works, but sometimes produces an upstream error in the mb draw lib
        }
      }
    });
    (0, _defineProperty2.default)(this, "_onClick", async (event, drawControl) => {
      const mbLngLatPoint = event.point;
      // Currently feature deletion is the only onClick handling
      if (!this.props.editLayer || this.props.drawShape !== _constants.DRAW_SHAPE.DELETE) {
        return;
      }
      const mbEditLayerIds = this.props.editLayer.getMbLayerIds().filter(mbLayerId => !!this.props.mbMap.getLayer(mbLayerId));
      const PADDING = 2; // in pixels
      const mbBbox = [{
        x: mbLngLatPoint.x - PADDING,
        y: mbLngLatPoint.y - PADDING
      }, {
        x: mbLngLatPoint.x + PADDING,
        y: mbLngLatPoint.y + PADDING
      }];
      const selectedFeatures = this.props.mbMap.queryRenderedFeatures(mbBbox, {
        layers: mbEditLayerIds,
        filter: ['all', _mb_filter_expressions.EXCLUDE_CENTROID_FEATURES]
      });
      if (!selectedFeatures.length) {
        return;
      }
      const topMostFeature = selectedFeatures[0];
      try {
        if (!(topMostFeature.properties && topMostFeature.properties._id)) {
          throw Error(`Associated Elasticsearch document id not found`);
        }
        const docId = topMostFeature.properties._id;
        this.props.deleteFeatureFromIndex(docId);
      } catch (error) {
        (0, _kibana_services.getToasts)().addWarning(_i18n.i18n.translate('xpack.maps.drawFeatureControl.unableToDeleteFeature', {
          defaultMessage: `Unable to delete feature, error: ''{errorMsg}''.`,
          values: {
            errorMsg: error.message
          }
        }));
      }
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_draw_control.DrawControl, {
      drawShape: this.props.drawShape,
      onDraw: this._onDraw,
      onClick: this._onClick,
      mbMap: this.props.mbMap,
      enable: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 7
      }
    });
  }
}
exports.DrawFeatureControl = DrawFeatureControl;