"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.canSkipFormattersUpdate = canSkipFormattersUpdate;
exports.canSkipSourceUpdate = canSkipSourceUpdate;
exports.canSkipStyleMetaUpdate = canSkipStyleMetaUpdate;
exports.updateDueToExtent = updateDueToExtent;
var _lodash = _interopRequireDefault(require("lodash"));
var _bboxPolygon = _interopRequireDefault(require("@turf/bbox-polygon"));
var _booleanContains = _interopRequireDefault(require("@turf/boolean-contains"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOURCE_UPDATE_REQUIRED = true;
const NO_SOURCE_UPDATE_REQUIRED = false;
function updateDueToExtent(prevMeta = {}, nextMeta = {}) {
  const {
    buffer: previousBuffer
  } = prevMeta;
  const {
    buffer: newBuffer
  } = nextMeta;
  if (!previousBuffer || !previousBuffer || !newBuffer) {
    return SOURCE_UPDATE_REQUIRED;
  }
  if (_lodash.default.isEqual(previousBuffer, newBuffer)) {
    return NO_SOURCE_UPDATE_REQUIRED;
  }
  const previousBufferGeometry = (0, _bboxPolygon.default)([previousBuffer.minLon, previousBuffer.minLat, previousBuffer.maxLon, previousBuffer.maxLat]);
  const newBufferGeometry = (0, _bboxPolygon.default)([newBuffer.minLon, newBuffer.minLat, newBuffer.maxLon, newBuffer.maxLat]);
  const doesPreviousBufferContainNewBuffer = (0, _booleanContains.default)(previousBufferGeometry, newBufferGeometry);
  const isTrimmed = _lodash.default.get(prevMeta, 'areResultsTrimmed', false);
  return doesPreviousBufferContainNewBuffer && !isTrimmed ? NO_SOURCE_UPDATE_REQUIRED : SOURCE_UPDATE_REQUIRED;
}
async function canSkipSourceUpdate({
  source,
  prevDataRequest,
  nextRequestMeta,
  extentAware,
  getUpdateDueToTimeslice
}) {
  const mustForceRefresh = nextRequestMeta.isForceRefresh && nextRequestMeta.applyForceRefresh;
  if (mustForceRefresh) {
    // Cannot skip
    return false;
  }
  const timeAware = await source.isTimeAware();
  const isFieldAware = source.isFieldAware();
  const isQueryAware = source.isQueryAware();
  if (!timeAware && !extentAware && !isFieldAware && !isQueryAware) {
    return !!prevDataRequest && prevDataRequest.hasDataOrRequestInProgress();
  }
  if (!prevDataRequest) {
    return false;
  }
  const prevMeta = prevDataRequest.getMeta();
  if (!prevMeta) {
    return false;
  }
  if (prevMeta.isFeatureEditorOpenForLayer !== nextRequestMeta.isFeatureEditorOpenForLayer) {
    return false;
  }
  let updateDueToApplyGlobalTime = false;
  let updateDueToTime = false;
  let updateDueToTimeslice = false;
  if (timeAware) {
    updateDueToApplyGlobalTime = prevMeta.applyGlobalTime !== nextRequestMeta.applyGlobalTime;
    if (nextRequestMeta.applyGlobalTime) {
      updateDueToTime = !_lodash.default.isEqual(prevMeta.timeFilters, nextRequestMeta.timeFilters);
      if (!_lodash.default.isEqual(prevMeta.timeslice, nextRequestMeta.timeslice)) {
        updateDueToTimeslice = getUpdateDueToTimeslice(nextRequestMeta.timeslice);
      }
    }
  }
  let updateDueToFields = false;
  if (isFieldAware) {
    updateDueToFields = !_lodash.default.isEqual(prevMeta.fieldNames, nextRequestMeta.fieldNames);
  }
  let updateDueToQuery = false;
  let updateDueToFilters = false;
  let updateDueToSourceQuery = false;
  let updateDueToApplyGlobalQuery = false;
  if (isQueryAware) {
    updateDueToApplyGlobalQuery = prevMeta.applyGlobalQuery !== nextRequestMeta.applyGlobalQuery;
    updateDueToSourceQuery = !_lodash.default.isEqual(prevMeta.sourceQuery, nextRequestMeta.sourceQuery);
    if (nextRequestMeta.applyGlobalQuery) {
      updateDueToQuery = !_lodash.default.isEqual(prevMeta.query, nextRequestMeta.query);
      updateDueToFilters = !_lodash.default.isEqual(prevMeta.filters, nextRequestMeta.filters);
    }
  }
  let updateDueToSearchSessionId = false;
  if ((timeAware || isQueryAware) && nextRequestMeta.applyForceRefresh) {
    // If the force-refresh flag is turned off, we should ignore refreshes on the dashboard-context
    updateDueToSearchSessionId = prevMeta.searchSessionId !== nextRequestMeta.searchSessionId;
  }
  let updateDueToExtentChange = false;
  if (extentAware) {
    updateDueToExtentChange = updateDueToExtent(prevMeta, nextRequestMeta);
  }
  const updateDueToSourceMetaChange = !_lodash.default.isEqual(prevMeta.sourceMeta, nextRequestMeta.sourceMeta);
  const updateDueToProjectRouting = prevMeta.projectRouting !== nextRequestMeta.projectRouting;
  return !updateDueToApplyGlobalTime && !updateDueToTime && !updateDueToTimeslice && !updateDueToExtentChange && !updateDueToFields && !updateDueToQuery && !updateDueToFilters && !updateDueToSourceQuery && !updateDueToApplyGlobalQuery && !updateDueToSourceMetaChange && !updateDueToSearchSessionId && !updateDueToProjectRouting;
}
function canSkipStyleMetaUpdate({
  prevDataRequest,
  nextMeta
}) {
  if (!prevDataRequest) {
    return false;
  }
  const prevMeta = prevDataRequest.getMeta();
  if (!prevMeta) {
    return false;
  }
  const updateDueToFields = !_lodash.default.isEqual(prevMeta.dynamicStyleFields, nextMeta.dynamicStyleFields);
  const updateDueToSourceQuery = !_lodash.default.isEqual(prevMeta.sourceQuery, nextMeta.sourceQuery);
  const updateDueToIsTimeAware = nextMeta.isTimeAware !== prevMeta.isTimeAware;
  const updateDueToTime = nextMeta.isTimeAware ? !_lodash.default.isEqual(prevMeta.timeFilters, nextMeta.timeFilters) : false;
  const updateDueToSearchSessionId = prevMeta.searchSessionId !== nextMeta.searchSessionId;
  return !updateDueToFields && !updateDueToSourceQuery && !updateDueToIsTimeAware && !updateDueToTime && !updateDueToSearchSessionId;
}
function canSkipFormattersUpdate({
  prevDataRequest,
  nextMeta
}) {
  if (!prevDataRequest) {
    return false;
  }
  const prevMeta = prevDataRequest.getMeta();
  if (!prevMeta) {
    return false;
  }
  return _lodash.default.isEqual(prevMeta.fieldNames, nextMeta.fieldNames);
}