"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DynamicColorProperty = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _dynamic_style_property = require("./dynamic_style_property");
var _style_util = require("../style_util");
var _color_palettes = require("../../color_palettes");
var _constants = require("../../../../../common/constants");
var _color_stops_utils = require("../components/color/color_stops_utils");
var _breaked_legend = require("../components/legend/breaked_legend");
var _ordinal_suffix = require("../../../util/ordinal_suffix");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/properties/dynamic_color_property.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UP_TO = _i18n.i18n.translate('xpack.maps.legend.upto', {
  defaultMessage: 'up to'
});
const RGBA_0000 = 'rgba(0,0,0,0)';
class DynamicColorProperty extends _dynamic_style_property.DynamicStyleProperty {
  constructor(options, styleName, field, vectorLayer, getFieldFormatter, chartsPaletteServiceGetColor) {
    super(options, styleName, field, vectorLayer, getFieldFormatter);
    (0, _defineProperty2.default)(this, "_chartsPaletteServiceGetColor", void 0);
    this._chartsPaletteServiceGetColor = chartsPaletteServiceGetColor;
  }
  syncCircleColorWithMb(mbLayerId, mbMap, alpha) {
    const color = this._getMbColor();
    mbMap.setPaintProperty(mbLayerId, 'circle-color', color);
    mbMap.setPaintProperty(mbLayerId, 'circle-opacity', alpha);
  }
  syncIconColorWithMb(mbLayerId, mbMap) {
    const color = this._getMbColor();
    mbMap.setPaintProperty(mbLayerId, 'icon-color', color);
  }
  syncHaloBorderColorWithMb(mbLayerId, mbMap) {
    const color = this._getMbColor();
    mbMap.setPaintProperty(mbLayerId, 'icon-halo-color', color);
  }
  syncCircleStrokeWithMb(pointLayerId, mbMap, alpha) {
    const color = this._getMbColor();
    mbMap.setPaintProperty(pointLayerId, 'circle-stroke-color', color);
    mbMap.setPaintProperty(pointLayerId, 'circle-stroke-opacity', alpha);
  }
  syncFillColorWithMb(mbLayerId, mbMap, alpha) {
    const color = this._getMbColor();
    mbMap.setPaintProperty(mbLayerId, 'fill-color', color);
    mbMap.setPaintProperty(mbLayerId, 'fill-opacity', alpha);
  }
  syncLineColorWithMb(mbLayerId, mbMap, alpha) {
    const color = this._getMbColor();
    mbMap.setPaintProperty(mbLayerId, 'line-color', color);
    mbMap.setPaintProperty(mbLayerId, 'line-opacity', alpha);
  }
  syncLabelColorWithMb(mbLayerId, mbMap, alpha) {
    const color = this._getMbColor();
    mbMap.setPaintProperty(mbLayerId, 'text-color', color);
    mbMap.setPaintProperty(mbLayerId, 'text-opacity', alpha);
  }
  syncLabelBorderColorWithMb(mbLayerId, mbMap) {
    const color = this._getMbColor();
    mbMap.setPaintProperty(mbLayerId, 'text-halo-color', color);
  }
  supportsFieldMeta() {
    if (!this.isComplete() || !this._field || !this._field.supportsFieldMetaFromEs()) {
      return false;
    }
    return this.isCategorical() && !this._options.useCustomColorPalette || this.isOrdinal() && !this._options.useCustomColorRamp;
  }
  isOrdinal() {
    return typeof this._options.type === 'undefined' || this._options.type === _constants.COLOR_MAP_TYPE.ORDINAL;
  }
  isCategorical() {
    return this._options.type === _constants.COLOR_MAP_TYPE.CATEGORICAL;
  }
  getNumberOfCategories() {
    if (!this._options.colorCategory) {
      return 0;
    }
    const colors = (0, _color_palettes.getColorPalette)(this._options.colorCategory);
    return colors ? colors.length : 0;
  }
  _getSupportedDataMappingFunctions() {
    return [_constants.DATA_MAPPING_FUNCTION.INTERPOLATE, _constants.DATA_MAPPING_FUNCTION.PERCENTILES];
  }
  _getMbColor() {
    if (!this.getMbFieldName()) {
      return null;
    }
    return this.isCategorical() ? this._getCategoricalColorMbExpression() : this._getOrdinalColorMbExpression();
  }
  _getOrdinalColorMbExpression() {
    const invert = this._options.invert === undefined ? false : this._options.invert;
    const targetName = this.getMbFieldName();
    if (this._options.useCustomColorRamp) {
      if (!this._options.customColorRamp || !this._options.customColorRamp.length) {
        // custom color ramp config is not complete
        return null;
      }
      const colorStops = this._options.customColorRamp.reduce((accumulatedStops, nextStop) => {
        return [...accumulatedStops, nextStop.stop, nextStop.color];
      }, []);
      return ['step', (0, _style_util.makeMbClampedNumberExpression)({
        minValue: colorStops[0],
        maxValue: colorStops[colorStops.length - 2],
        lookupFunction: this.getMbLookupFunction(),
        fallback: colorStops[0] - 1,
        fieldName: targetName
      }), RGBA_0000,
      // MB will assign the base value to any features that is below the first stop value
      ...colorStops];
    }
    if (this.getDataMappingFunction() === _constants.DATA_MAPPING_FUNCTION.PERCENTILES) {
      const percentilesFieldMeta = this.getPercentilesFieldMeta();
      if (!percentilesFieldMeta || !percentilesFieldMeta.length) {
        return null;
      }
      const colorStops = (0, _color_palettes.getPercentilesMbColorRampStops)(this._options.color ? this._options.color : null, percentilesFieldMeta, invert);
      if (!colorStops) {
        return null;
      }
      return ['step', (0, _style_util.makeMbClampedNumberExpression)({
        minValue: colorStops[0],
        maxValue: colorStops[colorStops.length - 2],
        lookupFunction: this.getMbLookupFunction(),
        fallback: colorStops[0] - 1,
        fieldName: targetName
      }), RGBA_0000, ...colorStops];
    }
    const rangeFieldMeta = this.getRangeFieldMeta();
    if (!rangeFieldMeta) {
      return null;
    }
    const colorStops = (0, _color_palettes.getOrdinalMbColorRampStops)(this._options.color ? this._options.color : null, rangeFieldMeta.min, rangeFieldMeta.max, invert);
    if (!colorStops) {
      return null;
    }
    const lessThanFirstStopValue = rangeFieldMeta.min - 1;
    return ['interpolate', ['linear'], (0, _style_util.makeMbClampedNumberExpression)({
      minValue: rangeFieldMeta.min,
      maxValue: rangeFieldMeta.max,
      lookupFunction: this.getMbLookupFunction(),
      fallback: lessThanFirstStopValue,
      fieldName: targetName
    }), lessThanFirstStopValue, RGBA_0000, ...colorStops];
  }
  _getCustomRampColorStops() {
    return this._options.customColorRamp ? this._options.customColorRamp.reduce((accumulatedStops, nextStop) => {
      return [...accumulatedStops, nextStop.stop, nextStop.color];
    }, []) : [];
  }
  _getOtherCategoryColor() {
    if (this._chartsPaletteServiceGetColor) {
      return this._chartsPaletteServiceGetColor('__other__');
    }
    return this._options.otherCategoryColor ? this._options.otherCategoryColor : _style_util.OTHER_CATEGORY_DEFAULT_COLOR;
  }
  _getColorPaletteStops() {
    if (this._options.useCustomColorPalette && this._options.customColorPalette) {
      if ((0, _color_stops_utils.isCategoricalStopsInvalid)(this._options.customColorPalette)) {
        return [];
      }
      const stops = [];
      for (let i = 0; i < this._options.customColorPalette.length; i++) {
        const config = this._options.customColorPalette[i];
        stops.push({
          stop: config.stop,
          color: config.color,
          isOtherCategory: false
        });
      }

      // Custom color palette does not support field meta so there is no way of knowing whether "others" category is used
      // Because of this limitation, "others" categor will always be displayed in legend
      return [...stops, {
        stop: _dynamic_style_property.OTHER_CATEGORY_KEY,
        color: this._getOtherCategoryColor(),
        isOtherCategory: true
      }];
    }
    const categories = this.getCategoryFieldMeta();
    const colors = this._options.colorCategory ? (0, _color_palettes.getColorPalette)(this._options.colorCategory) : null;
    if (categories.length === 0 || !colors) {
      return [];
    }
    const othersCategoryIndex = categories.findIndex(category => {
      return category.key === _dynamic_style_property.OTHER_CATEGORY_KEY;
    });
    // Do not include "others" category when assigning colors
    // "real" means category is from data value and not a virtual category (like "others")
    const realCategories = othersCategoryIndex > 0 ? [...categories.slice(0, othersCategoryIndex), ...categories.slice(othersCategoryIndex + 1)] : [...categories];
    const maxLength = Math.min(colors.length, realCategories.length);
    const stops = [];
    for (let i = 0; i < maxLength; i++) {
      stops.push({
        stop: realCategories[i].key,
        color: this._chartsPaletteServiceGetColor ? this._chartsPaletteServiceGetColor(realCategories[i].key) : colors[i],
        isOtherCategory: false
      });
    }
    return othersCategoryIndex > 0 ? [...stops, {
      stop: _dynamic_style_property.OTHER_CATEGORY_KEY,
      color: this._getOtherCategoryColor(),
      isOtherCategory: true
    }] : stops;
  }
  _getCategoricalColorMbExpression() {
    const otherCategoryColor = this._getOtherCategoryColor();
    if (this._options.useCustomColorPalette && (!this._options.customColorPalette || !this._options.customColorPalette.length)) {
      return otherCategoryColor;
    }
    const stops = this._getColorPaletteStops();
    if (stops.length < 1) {
      // occurs when no data
      return otherCategoryColor;
    }
    const mbStops = [];
    for (let i = 0; i < stops.length; i++) {
      const stop = stops[i];
      if (!stop.isOtherCategory) {
        mbStops.push(`${stop.stop}`);
        mbStops.push(stop.color);
      }
    }
    mbStops.push(otherCategoryColor); // color for unmatched values
    return ['match', ['to-string', ['get', this.getMbFieldName()]], ...mbStops];
  }
  _getOrdinalBreaks(symbolId, svg) {
    const invert = this._options.invert === undefined ? false : this._options.invert;
    let colorStops = null;
    let getValuePrefix = null;
    if (this._options.useCustomColorRamp) {
      if (!this._options.customColorRamp) {
        return [];
      }
      colorStops = this._getCustomRampColorStops();
    } else if (this.getDataMappingFunction() === _constants.DATA_MAPPING_FUNCTION.PERCENTILES) {
      const percentilesFieldMeta = this.getPercentilesFieldMeta();
      if (!percentilesFieldMeta) {
        return [];
      }
      colorStops = (0, _color_palettes.getPercentilesMbColorRampStops)(this._options.color ? this._options.color : null, percentilesFieldMeta, invert);
      getValuePrefix = function (i, isNext) {
        const percentile = isNext ? parseFloat(percentilesFieldMeta[i / 2 + 1].percentile) : parseFloat(percentilesFieldMeta[i / 2].percentile);
        return `${percentile}${(0, _ordinal_suffix.getOrdinalSuffix)(percentile)}: `;
      };
    } else {
      const rangeFieldMeta = this.getRangeFieldMeta();
      if (!rangeFieldMeta || !this._options.color) {
        return [];
      }
      if (rangeFieldMeta.delta === 0) {
        const colors = invert ? (0, _color_palettes.getColorPalette)(this._options.color).reverse() : (0, _color_palettes.getColorPalette)(this._options.color);
        // map to last color.
        return [{
          color: colors[colors.length - 1],
          label: this.formatField((0, _style_util.dynamicRound)(rangeFieldMeta.max)),
          symbolId,
          svg
        }];
      }
      colorStops = (0, _color_palettes.getOrdinalMbColorRampStops)(this._options.color ? this._options.color : null, rangeFieldMeta.min, rangeFieldMeta.max, invert);
    }
    if (!colorStops || colorStops.length <= 2) {
      return [];
    }
    const breaks = [];
    const lastStopIndex = colorStops.length - 2;
    for (let i = 0; i < colorStops.length; i += 2) {
      const hasNext = i < lastStopIndex;
      const stopValue = colorStops[i];
      const formattedStopValue = this.formatField((0, _style_util.dynamicRound)(stopValue));
      const color = colorStops[i + 1];
      const valuePrefix = getValuePrefix ? getValuePrefix(i, false) : '';
      let label = '';
      if (!hasNext) {
        label = `>= ${valuePrefix}${formattedStopValue}`;
      } else {
        const nextStopValue = colorStops[i + 2];
        const formattedNextStopValue = this.formatField((0, _style_util.dynamicRound)(nextStopValue));
        const nextValuePrefix = getValuePrefix ? getValuePrefix(i, true) : '';
        if (i === 0) {
          label = `< ${nextValuePrefix}${formattedNextStopValue}`;
        } else {
          const begin = `${valuePrefix}${formattedStopValue}`;
          const end = `${nextValuePrefix}${formattedNextStopValue}`;
          label = `${begin} ${UP_TO} ${end}`;
        }
      }
      breaks.push({
        color,
        label,
        symbolId,
        svg
      });
    }
    return breaks;
  }
  _getCategoricalBreaks(symbolId, svg) {
    const breaks = [];
    const stops = this._getColorPaletteStops();
    stops.forEach(({
      stop,
      color,
      isOtherCategory
    }) => {
      if (stop !== null && color != null) {
        breaks.push({
          color,
          svg,
          symbolId,
          label: isOtherCategory ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
            color: "subdued",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 467,
              columnNumber: 15
            }
          }, _style_util.OTHER_CATEGORY_LABEL) : this.formatField(stop)
        });
      }
    });
    return breaks;
  }
  renderLegendDetailRow({
    isPointsOnly,
    isLinesOnly,
    symbolId,
    svg
  }) {
    let breaks = [];
    if (this.isOrdinal()) {
      breaks = this._getOrdinalBreaks(symbolId, svg);
    } else if (this.isCategorical()) {
      breaks = this._getCategoricalBreaks(symbolId, svg);
    }
    return /*#__PURE__*/_react.default.createElement(_breaked_legend.BreakedLegend, {
      style: this,
      breaks: breaks,
      isPointsOnly: isPointsOnly,
      isLinesOnly: isLinesOnly,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 486,
        columnNumber: 7
      }
    });
  }
}
exports.DynamicColorProperty = DynamicColorProperty;