"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.staticSizeShape = exports.staticOrientationShape = exports.staticColorShape = exports.dynamicSizeShape = exports.dynamicOrientationShape = exports.dynamicColorShape = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _field_select = require("./field_select");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const staticColorShape = exports.staticColorShape = _propTypes.default.shape({
  color: _propTypes.default.string.isRequired
});
const dynamicColorShape = exports.dynamicColorShape = _propTypes.default.shape({
  color: _propTypes.default.string,
  field: _field_select.fieldShape,
  customColorRamp: _propTypes.default.array,
  useCustomColorRamp: _propTypes.default.bool
});
const staticOrientationShape = exports.staticOrientationShape = _propTypes.default.shape({
  orientation: _propTypes.default.number.isRequired
});
const dynamicOrientationShape = exports.dynamicOrientationShape = _propTypes.default.shape({
  field: _field_select.fieldShape
});
const staticSizeShape = exports.staticSizeShape = _propTypes.default.shape({
  size: _propTypes.default.number.isRequired
});
const dynamicSizeShape = exports.dynamicSizeShape = _propTypes.default.shape({
  minSize: _propTypes.default.number.isRequired,
  maxSize: _propTypes.default.number.isRequired,
  field: _field_select.fieldShape
});