"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _tooltip_selector = require("../../../components/tooltip_selector");
var _mvt_single_layer_source_settings = require("./mvt_single_layer_source_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/mvt_single_layer_vector_source/update_source_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line @typescript-eslint/no-empty-interface

class UpdateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_onTooltipPropertiesSelect", propertyNames => {
      this.props.onChange({
        propName: 'tooltipProperties',
        value: propertyNames
      });
    });
    (0, _defineProperty2.default)(this, "_handleChange", settings => {
      const changes = [];
      if (settings.layerName !== this.props.source.getTileSourceLayer()) {
        changes.push({
          propName: 'layerName',
          value: settings.layerName
        });
      }
      if (settings.minSourceZoom !== this.props.source.getMinZoom()) {
        changes.push({
          propName: 'minSourceZoom',
          value: settings.minSourceZoom
        });
      }
      if (settings.maxSourceZoom !== this.props.source.getMaxZoom()) {
        changes.push({
          propName: 'maxSourceZoom',
          value: settings.maxSourceZoom
        });
      }
      if (!_lodash.default.isEqual(settings.fields, this._getFieldDescriptors())) {
        changes.push({
          propName: 'fields',
          value: settings.fields
        });

        // Remove dangling tooltips.
        // This behaves similar to how stale styling properties are removed (e.g. on metric-change in agg sources)
        const sanitizedTooltips = [];
        for (let i = 0; i < this.props.tooltipFields.length; i++) {
          const tooltipName = this.props.tooltipFields[i].getName();
          for (let j = 0; j < settings.fields.length; j++) {
            if (settings.fields[j].name === tooltipName) {
              sanitizedTooltips.push(tooltipName);
              break;
            }
          }
        }
        if (!_lodash.default.isEqual(sanitizedTooltips, this.props.tooltipFields)) {
          changes.push({
            propName: 'tooltipProperties',
            value: sanitizedTooltips
          });
        }
      }
      this.props.onChange(...changes);
    });
  }
  _getFieldDescriptors() {
    return this.props.source.getMVTFields().map(field => {
      return field.getMVTFieldDescriptor();
    });
  }
  _renderSourceSettingsCard() {
    const fieldDescriptors = this._getFieldDescriptors();
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.mvtSource.sourceSettings",
      defaultMessage: "Source settings",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_mvt_single_layer_source_settings.MVTSingleLayerSourceSettings, {
      handleChange: this._handleChange,
      layerName: this.props.source.getTileSourceLayer() || '',
      fields: fieldDescriptors,
      minSourceZoom: this.props.source.getMinZoom(),
      maxSourceZoom: this.props.source.getMaxZoom(),
      showFields: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }));
  }
  _renderTooltipSelectionCard() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.mvtSource.tooltipsTitle",
      defaultMessage: "Tooltip fields",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_tooltip_selector.TooltipSelector, {
      tooltipFields: this.props.tooltipFields // selected fields in the tooltip
      ,
      onChange: this._onTooltipPropertiesSelect,
      fields: this.props.source.getMVTFields() // all the fields in the source
      ,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 9
      }
    }));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 7
      }
    }, this._renderSourceSettingsCard(), this._renderTooltipSelectionCard());
  }
}
exports.UpdateSourceEditor = UpdateSourceEditor;