"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NarrowByMapBounds = NarrowByMapBounds;
exports.NarrowByTime = NarrowByTime;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _esqlUtils = require("@kbn/esql-utils");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/esql_source/narrow_by_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function NarrowByMapBounds(props) {
  return /*#__PURE__*/_react.default.createElement(NarrowByField, (0, _extends2.default)({
    switchLabel: _i18n.i18n.translate('xpack.maps.esqlSource.narrowByMapExtentLabel', {
      defaultMessage: 'Dynamically filter for data in the visible map area'
    }),
    fieldTypes: [_constants.ES_GEO_FIELD_TYPE.GEO_POINT, _constants.ES_GEO_FIELD_TYPE.GEO_SHAPE]
  }, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  }));
}
function NarrowByTime(props) {
  return /*#__PURE__*/_react.default.createElement(NarrowByField, (0, _extends2.default)({
    switchLabel: _i18n.i18n.translate('xpack.maps.esqlSource.narrowByGlobalTimeLabel', {
      defaultMessage: `Apply global time range to ES|QL statement`
    }),
    fieldTypes: ['date']
  }, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }));
}
function NarrowByField(props) {
  const options = (0, _react.useMemo)(() => {
    return props.fields.map(field => {
      return {
        value: field,
        text: field
      };
    });
  }, [props.fields]);
  const narrowBySwitch = /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: props.switchLabel,
    checked: props.narrowByField,
    onChange: event => {
      props.onNarrowByFieldChange(event.target.checked);
    },
    disabled: props.fields.length === 0,
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, props.fields.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.maps.esqlSource.noFieldsMsg', {
      defaultMessage: `No {fieldTypes} fields are available from index pattern: {pattern}.`,
      values: {
        fieldTypes: props.fieldTypes.map(type => {
          return `'${type}'`;
        }).join(', '),
        pattern: (0, _esqlUtils.getIndexPatternFromESQLQuery)(props.esql)
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, narrowBySwitch) : narrowBySwitch), props.narrowByField && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.source.esql.narrowByFieldLabel', {
      defaultMessage: 'Filter by'
    }),
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: options,
    value: props.field,
    onChange: e => {
      props.onFieldChange(e.target.value);
    },
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  })));
}