"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourceTitle = exports.ESQLSource = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _cryptoBrowser = require("@kbn/crypto-browser");
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _esqlUtils = require("@kbn/esql-utils");
var _esQuery = require("@kbn/es-query");
var _es_query = require("@kbn/data-service/src/es_query");
var _public = require("@kbn/data-plugin/public");
var _std = require("@kbn/std");
var _constants = require("../../../../common/constants");
var _elasticsearch_util = require("../../../../common/elasticsearch_util");
var _valid_string_config = require("../../util/valid_string_config");
var _vector_source = require("../vector_source");
var _kibana_services = require("../../../kibana_services");
var _convert_to_geojson = require("./convert_to_geojson");
var _esql_utils = require("./esql_utils");
var _update_source_editor = require("./update_source_editor");
var _esql_field = require("../../fields/esql_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/esql_source/esql_source.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const sourceTitle = exports.sourceTitle = _i18n.i18n.translate('xpack.maps.source.esqlSearchTitle', {
  defaultMessage: 'ES|QL'
});
class ESQLSource extends _vector_source.AbstractVectorSource {
  static createDescriptor(descriptor) {
    if (!(0, _valid_string_config.isValidStringConfig)(descriptor.esql)) {
      throw new Error('Cannot create ESQLSourceDescriptor when esql is not provided');
    }
    return {
      ...descriptor,
      id: (0, _valid_string_config.isValidStringConfig)(descriptor.id) ? descriptor.id : (0, _uuid.v4)(),
      type: _constants.SOURCE_TYPES.ESQL,
      esql: descriptor.esql,
      narrowByGlobalSearch: typeof descriptor.narrowByGlobalSearch !== 'undefined' ? descriptor.narrowByGlobalSearch : true,
      narrowByGlobalTime: typeof descriptor.narrowByGlobalTime !== 'undefined' ? descriptor.narrowByGlobalTime : descriptor.dateField !== 'undefined',
      narrowByMapBounds: typeof descriptor.narrowByMapBounds !== 'undefined' ? descriptor.narrowByMapBounds : descriptor.geoField !== 'undefined',
      applyForceRefresh: typeof descriptor.applyForceRefresh !== 'undefined' ? descriptor.applyForceRefresh : true
    };
  }
  constructor(partialDescriptor) {
    const descriptor = ESQLSource.createDescriptor(partialDescriptor);
    super(descriptor);
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    (0, _defineProperty2.default)(this, "_dataViewId", void 0);
    (0, _defineProperty2.default)(this, "getTooltipProperties", async mbProperties => {
      if (!mbProperties) return [];
      const keys = Object.keys(mbProperties).filter(key => key !== _constants.GEOJSON_FEATURE_ID_PROPERTY_NAME);
      return (0, _std.asyncMap)(keys, async key => {
        return await this.getFieldByName(key).createTooltipProperty(mbProperties[key]);
      });
    });
    (0, _defineProperty2.default)(this, "_getDataViewFields", async () => {
      return (0, _esql_utils.getFields)(await this.getIndexPattern());
    });
    this._descriptor = descriptor;
  }
  _getRequestId() {
    return this._descriptor.id;
  }
  async getDisplayName() {
    const pattern = (0, _esqlUtils.getIndexPatternFromESQLQuery)(this._descriptor.esql);
    return pattern ? pattern : 'ES|QL';
  }
  hasTooltipProperties() {
    return true;
  }
  async supportsFitToBounds() {
    return false;
  }
  getInspectorRequestIds() {
    return [this._getRequestId()];
  }
  isQueryAware() {
    return true;
  }
  getApplyGlobalQuery() {
    return this._descriptor.narrowByGlobalSearch || (0, _esqlUtils.hasStartEndParams)(this._descriptor.esql);
  }
  async isTimeAware() {
    return this._descriptor.narrowByGlobalTime || (0, _esqlUtils.hasStartEndParams)(this._descriptor.esql);
  }
  getApplyGlobalTime() {
    return this._descriptor.narrowByGlobalTime;
  }
  getApplyForceRefresh() {
    return this._descriptor.applyForceRefresh;
  }
  isFilterByMapBounds() {
    return this._descriptor.narrowByMapBounds;
  }
  async getSupportedShapeTypes() {
    const columns = await (0, _esqlUtils.getESQLQueryColumnsRaw)({
      esqlQuery: this._descriptor.esql,
      search: (0, _kibana_services.getData)().search.search,
      timeRange: (0, _kibana_services.getData)().query.timefilter.timefilter.getAbsoluteTime()
    });
    const geoColumn = columns.find(_esql_utils.isGeometryColumn);
    return (geoColumn === null || geoColumn === void 0 ? void 0 : geoColumn.type) === _esql_utils.ESQL_GEO_SHAPE_TYPE ? [_constants.VECTOR_SHAPE_TYPE.POINT, _constants.VECTOR_SHAPE_TYPE.LINE, _constants.VECTOR_SHAPE_TYPE.POLYGON] : [_constants.VECTOR_SHAPE_TYPE.POINT];
  }
  supportsJoins() {
    return false; // Joins will be part of ESQL statement and not client side join
  }
  async getGeoJsonWithMeta(layerName, requestMeta, registerCancelCallback, isRequestStillActive, inspectorAdapters) {
    const limit = (0, _esqlUtils.getLimitFromESQLQuery)(this._descriptor.esql);
    const params = {
      query: this._descriptor.esql,
      dropNullColumns: true
    };
    const query = [];
    const filters = [];
    if (this._descriptor.narrowByGlobalSearch) {
      var _requestMeta$embeddab;
      if (requestMeta.query) {
        query.push(requestMeta.query);
      }
      if ((_requestMeta$embeddab = requestMeta.embeddableSearchContext) !== null && _requestMeta$embeddab !== void 0 && _requestMeta$embeddab.query) {
        query.push(requestMeta.embeddableSearchContext.query);
      }
      filters.push(...requestMeta.filters);
      if (requestMeta.embeddableSearchContext) {
        filters.push(...requestMeta.embeddableSearchContext.filters);
      }
    }
    if (this._descriptor.narrowByMapBounds && requestMeta.buffer) {
      if (!this._descriptor.geoField) {
        throw new Error(_i18n.i18n.translate('xpack.maps.source.esql.noGeoFieldError', {
          defaultMessage: 'Unable to narrow ES|QL statement by visible map area, geospatial field is not provided'
        }));
      }
      const extentFilter = (0, _elasticsearch_util.createExtentFilter)(requestMeta.buffer, [this._descriptor.geoField]);
      filters.push(extentFilter);
    }
    const timeRange = requestMeta.timeslice ? {
      from: new Date(requestMeta.timeslice.from).toISOString(),
      to: new Date(requestMeta.timeslice.to).toISOString(),
      mode: 'absolute'
    } : requestMeta.timeFilters;
    if (requestMeta.applyGlobalTime) {
      if (!this._descriptor.dateField) {
        throw new Error(_i18n.i18n.translate('xpack.maps.source.esql.noDateFieldError', {
          defaultMessage: 'Unable to narrow ES|QL statement by global time, date field is not provided'
        }));
      }
      const timeFilter = (0, _public.getTime)(undefined, timeRange, {
        fieldName: this._descriptor.dateField
      });
      if (timeFilter) {
        filters.push(timeFilter);
      }
    }
    const namedParams = (0, _esqlUtils.getStartEndParams)(this._descriptor.esql, timeRange);
    if (namedParams.length) {
      params.params = namedParams;
    }
    params.filter = (0, _esQuery.buildEsQuery)(undefined, query, filters, (0, _es_query.getEsQueryConfig)((0, _kibana_services.getUiSettings)()));
    if (requestMeta.projectRouting) {
      params.project_routing = (0, _esQuery.sanitizeProjectRoutingForES)(requestMeta.projectRouting);
    }
    const requestResponder = inspectorAdapters.requests.start((0, _vector_source.getLayerFeaturesRequestName)(layerName), {
      id: this._getRequestId()
    });
    requestResponder.json(params);
    const {
      rawResponse,
      requestParams
    } = await (0, _rxjs.lastValueFrom)((0, _kibana_services.getData)().search.search({
      params
    }, {
      strategy: 'esql'
    }).pipe((0, _rxjs.tap)({
      error(error) {
        requestResponder.error({
          json: 'attributes' in error ? error.attributes : {
            message: error.message
          }
        });
      }
    })));
    requestResponder.ok({
      json: rawResponse,
      requestParams
    });
    const esqlSearchResponse = rawResponse;
    const resultsCount = esqlSearchResponse.values.length;
    return {
      data: (0, _convert_to_geojson.convertToGeoJson)(esqlSearchResponse),
      meta: {
        resultsCount,
        areResultsTrimmed: resultsCount >= limit
      }
    };
  }
  getSourceStatus(sourceDataRequest) {
    var _meta$resultsCount2;
    const meta = sourceDataRequest ? sourceDataRequest.getMeta() : null;
    if (!meta) {
      // no tooltip content needed when there is no feature collection or meta
      return {
        tooltipContent: null,
        areResultsTrimmed: false
      };
    }
    if (meta.areResultsTrimmed) {
      var _meta$resultsCount;
      return {
        tooltipContent: _i18n.i18n.translate('xpack.maps.esqlSearch.resultsTrimmedMsg', {
          defaultMessage: `Results limited to first {count} rows.`,
          values: {
            count: (_meta$resultsCount = meta.resultsCount) === null || _meta$resultsCount === void 0 ? void 0 : _meta$resultsCount.toLocaleString()
          }
        }),
        areResultsTrimmed: true
      };
    }
    return {
      tooltipContent: _i18n.i18n.translate('xpack.maps.esqlSearch.rowCountMsg', {
        defaultMessage: `Found {count} rows.`,
        values: {
          count: (_meta$resultsCount2 = meta.resultsCount) === null || _meta$resultsCount2 === void 0 ? void 0 : _meta$resultsCount2.toLocaleString()
        }
      }),
      areResultsTrimmed: false
    };
  }
  getFieldByName(fieldName) {
    return new _esql_field.ESQLField({
      fieldName,
      source: this,
      origin: _constants.FIELD_ORIGIN.SOURCE
    });
  }
  async getFields() {
    const columns = await (0, _esqlUtils.getESQLQueryColumnsRaw)({
      esqlQuery: this.getESQL(),
      search: (0, _kibana_services.getData)().search.search,
      timeRange: (0, _kibana_services.getData)().query.timefilter.timefilter.getAbsoluteTime()
    });
    return columns.map(({
      name
    }) => this.getFieldByName(name));
  }
  renderSourceSettingsEditor({
    onChange
  }) {
    return /*#__PURE__*/_react.default.createElement(_update_source_editor.UpdateSourceEditor, {
      onChange: onChange,
      sourceDescriptor: this._descriptor,
      getDataViewFields: this._getDataViewFields,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 359,
        columnNumber: 7
      }
    });
  }
  getSyncMeta() {
    return {
      dateField: this._descriptor.dateField,
      esql: this._descriptor.esql,
      geoField: this._descriptor.geoField,
      narrowByMapBounds: this._descriptor.narrowByMapBounds,
      narrowByGlobalTime: this._descriptor.narrowByGlobalTime
    };
  }
  getIndexPatternId() {
    if (this._dataViewId) return this._dataViewId;

    // Can not use getESQLAdHocDataview to create adhocDataViewId because it's async
    // getESQLAdHocDataview is async because `crypto.subtle.digest` is async
    // getESQLAdHocDataview falls back to `@kbn/crypto-browser` when `crypto` is not available
    // we will just always use the fallback implemenation.
    const indexPattern = (0, _esqlUtils.getIndexPatternFromESQLQuery)(this._descriptor.esql);
    this._dataViewId = new _cryptoBrowser.Sha256().update(`esql-${indexPattern}`).digest('hex');
    return this._dataViewId;
  }
  getIndexPattern() {
    return (0, _esqlUtils.getESQLAdHocDataview)({
      dataViewsService: (0, _kibana_services.getIndexPatternService)(),
      query: this._descriptor.esql,
      http: (0, _kibana_services.getHttp)()
    });
  }
  getGeoFieldName() {
    return this._descriptor.geoField;
  }
  getESQL() {
    return this._descriptor.esql;
  }
  getProjectRouting() {
    return (0, _esqlUtils.getProjectRoutingFromEsqlQuery)(this.getESQL());
  }
}
exports.ESQLSource = ESQLSource;