"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasESSourceMethod = hasESSourceMethod;
exports.isESSource = isESSource;
exports.isESVectorTileSource = isESVectorTileSource;
var _vector_source = require("../vector_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isESVectorTileSource(source) {
  return (0, _vector_source.hasVectorSourceMethod)(source, 'isMvt') && source.isMvt() && hasESSourceMethod(source, 'getIndexPatternId');
}
function isESSource(source) {
  return typeof source.getId === 'function' && typeof source.getIndexPattern === 'function' && typeof source.getIndexPatternId === 'function' && typeof source.getGeoFieldName === 'function' && typeof source.loadStylePropsMeta === 'function';
}
function hasESSourceMethod(source, methodName) {
  return typeof source[methodName] === 'function';
}