"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESDocField = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/data-views-plugin/common");
var _es_tooltip_property = require("../tooltips/es_tooltip_property");
var _tooltip_property = require("../tooltips/tooltip_property");
var _field = require("./field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ESDocField extends _field.AbstractField {
  constructor({
    fieldName,
    source,
    origin
  }) {
    super({
      fieldName,
      origin
    });
    (0, _defineProperty2.default)(this, "_source", void 0);
    this._source = source;
  }
  supportsFieldMetaFromEs() {
    return true;
  }
  supportsFieldMetaFromLocalData() {
    // Elasticsearch vector tile search API does not return meta tiles for documents
    return !this.getSource().isMvt();
  }
  canValueBeFormatted() {
    return true;
  }
  getSource() {
    return this._source;
  }
  async _getIndexPatternField() {
    const indexPattern = await this._source.getIndexPattern();
    const indexPatternField = indexPattern.fields.getByName(this.getName());
    return indexPatternField && (0, _common.isNestedField)(indexPatternField) ? undefined : indexPatternField;
  }
  async createTooltipProperty(value) {
    const indexPattern = await this._source.getIndexPattern();
    const tooltipProperty = new _tooltip_property.TooltipProperty(this.getName(), await this.getLabel(), value);
    return new _es_tooltip_property.ESTooltipProperty(tooltipProperty, indexPattern, this, this._source.getApplyGlobalQuery());
  }
  async getDataType() {
    const indexPatternField = await this._getIndexPatternField();
    return indexPatternField ? indexPatternField.type : '';
  }
  async getLabel() {
    const indexPatternField = await this._getIndexPatternField();
    return indexPatternField && indexPatternField.displayName ? indexPatternField.displayName : super.getLabel();
  }
  async getExtendedStatsFieldMetaRequest() {
    const indexPatternField = await this._getIndexPatternField();
    if (!indexPatternField || indexPatternField.type !== 'number' && indexPatternField.type !== 'date') {
      return null;
    }
    const metricAggConfig = {};
    if (indexPatternField.scripted && indexPatternField.script) {
      metricAggConfig.script = {
        source: indexPatternField.script,
        lang: indexPatternField.lang
      };
    } else {
      metricAggConfig.field = this.getName();
    }
    return {
      [`${this.getName()}_range`]: {
        extended_stats: metricAggConfig
      }
    };
  }
  async getPercentilesFieldMetaRequest(percentiles) {
    const indexPatternField = await this._getIndexPatternField();
    if (!indexPatternField || indexPatternField.type !== 'number') {
      return null;
    }
    const metricAggConfig = {
      percents: [0, ...percentiles]
    };
    if (indexPatternField.scripted && indexPatternField.script) {
      metricAggConfig.script = {
        source: indexPatternField.script,
        lang: indexPatternField.lang
      };
    } else {
      metricAggConfig.field = this.getName();
    }
    return {
      [`${this.getName()}_percentiles`]: {
        percentiles: metricAggConfig
      }
    };
  }
  async getCategoricalFieldMetaRequest(size) {
    const indexPatternField = await this._getIndexPatternField();
    if (!indexPatternField || size <= 0) {
      return null;
    }
    const topTerms = {
      size
    };
    if (indexPatternField.scripted && indexPatternField.script) {
      topTerms.script = {
        source: indexPatternField.script,
        lang: indexPatternField.lang
      };
    } else {
      topTerms.field = this.getName();
    }
    return {
      [`${this.getName()}_terms`]: {
        terms: topTerms
      }
    };
  }
}
exports.ESDocField = ESDocField;