"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsEnterprisePlus = getIsEnterprisePlus;
exports.setKibanaVersion = exports.getMapConfig = exports.getKibanaVersion = void 0;
exports.setLicensingPluginStart = setLicensingPluginStart;
exports.setMapConfig = void 0;
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

let kibanaVersion;
const setKibanaVersion = version => kibanaVersion = version;
exports.setKibanaVersion = setKibanaVersion;
const getKibanaVersion = () => kibanaVersion;
exports.getKibanaVersion = getKibanaVersion;
let mapsEmsConfig;
const setMapConfig = mapsEms => {
  mapsEmsConfig = mapsEms;
};
exports.setMapConfig = setMapConfig;
const getMapConfig = () => mapsEmsConfig;
exports.getMapConfig = getMapConfig;
let isEnterprisePlus = false;
function updateLicenseState(license) {
  const enterprise = license.check(_common.LICENSE_CHECK_ID, 'enterprise');
  isEnterprisePlus = enterprise.state === 'valid';
}
function getIsEnterprisePlus() {
  return isEnterprisePlus;
}
async function setLicensingPluginStart(licensingPlugin) {
  const license = await licensingPlugin.getLicense();
  updateLicenseState(license);
  licensingPlugin.license$.subscribe(updateLicenseState);
}