"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.maintenanceWindowModelVersions = void 0;
var _schema = require("./schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maintenanceWindowModelVersions = exports.maintenanceWindowModelVersions = {
  '1': {
    changes: [],
    schemas: {
      forwardCompatibility: _schema.rawMaintenanceWindowSchemaV1.extends({}, {
        unknowns: 'ignore'
      }),
      create: _schema.rawMaintenanceWindowSchemaV1
    }
  },
  '2': {
    changes: [{
      type: 'mappings_addition',
      addedMappings: {
        title: {
          type: 'text',
          fields: {
            keyword: {
              type: 'keyword'
            }
          }
        },
        expirationDate: {
          type: 'date'
        },
        updatedAt: {
          type: 'date'
        }
      }
    }],
    schemas: {
      forwardCompatibility: _schema.rawMaintenanceWindowSchemaV1.extends({}, {
        unknowns: 'ignore'
      })
    }
  },
  '3': {
    changes: [{
      type: 'mappings_addition',
      addedMappings: {
        createdBy: {
          type: 'keyword'
        }
      }
    }],
    schemas: {
      forwardCompatibility: _schema.rawMaintenanceWindowSchemaV1.extends({}, {
        unknowns: 'ignore'
      })
    }
  }
};