"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMaintenanceWindowParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _maintenance_window = require("../../../schemas/maintenance_window");
var _alerts_filter_query_schemas = require("../../../schemas/alerts_filter_query_schemas");
var _r_rule = require("../../../../routes/apis/r_rule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMaintenanceWindowParamsSchema = exports.createMaintenanceWindowParamsSchema = _configSchema.schema.object({
  data: _configSchema.schema.object({
    title: _configSchema.schema.string(),
    duration: _configSchema.schema.number(),
    rRule: _r_rule.rRuleRequestSchema,
    categoryIds: _maintenance_window.maintenanceWindowCategoryIdsSchema,
    scopedQuery: _configSchema.schema.maybe(_configSchema.schema.nullable(_alerts_filter_query_schemas.alertsFilterQuerySchema)),
    enabled: _configSchema.schema.maybe(_configSchema.schema.boolean({
      defaultValue: true
    }))
  })
});