"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTimestampColumn = exports.isMessageColumn = exports.isFieldSegment = exports.isFieldColumn = exports.isConstantSegment = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isTimestampColumn = column => column != null && 'time' in column;
exports.isTimestampColumn = isTimestampColumn;
const isMessageColumn = column => column != null && 'message' in column;
exports.isMessageColumn = isMessageColumn;
const isFieldColumn = column => column != null && 'field' in column;
exports.isFieldColumn = isFieldColumn;
const isConstantSegment = segment => 'constant' in segment;
exports.isConstantSegment = isConstantSegment;
const isFieldSegment = segment => 'field' in segment && 'value' in segment;
exports.isFieldSegment = isFieldSegment;