"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsSharedPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _locators = require("../common/locators");
var _log_ai_assistant = require("./components/log_ai_assistant");
var _logs_overview = require("./components/logs_overview");
var _log_views = require("./services/log_views");
var _log_events = require("./components/log_events");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class LogsSharedPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "logViews", void 0);
    this.logViews = new _log_views.LogViewsService();
  }
  setup(coreSetup, pluginsSetup) {
    const logViews = this.logViews.setup();
    const logsLocator = pluginsSetup.share.url.locators.create(new _locators.LogsLocatorDefinition({
      locators: pluginsSetup.share.url.locators,
      getLogSourcesService: async () => {
        const [_, pluginsStart] = await coreSetup.getStartServices();
        return pluginsStart.logsDataAccess.services.logSourcesService;
      }
    }));
    const locators = {
      logsLocator
    };
    return {
      logViews,
      locators
    };
  }
  start(core, plugins) {
    var _plugins$ml;
    const {
      http,
      settings,
      theme
    } = core;
    const {
      charts,
      data,
      dataViews,
      discoverShared,
      logsDataAccess,
      observabilityAIAssistant,
      share
    } = plugins;
    const logViews = this.logViews.start({
      http,
      dataViews,
      logSourcesService: logsDataAccess.services.logSourcesService,
      search: data.search
    });
    const LogsOverview = (0, _logs_overview.createLogsOverview)({
      charts,
      logsDataAccess,
      search: data.search.search,
      searchSource: data.search.searchSource,
      uiSettings: settings,
      share,
      dataViews,
      embeddable: plugins.embeddable,
      mlApi: (_plugins$ml = plugins.ml) === null || _plugins$ml === void 0 ? void 0 : _plugins$ml.mlApi,
      theme
    });
    if (!observabilityAIAssistant) {
      return {
        logViews,
        LogsOverview
      };
    }
    const LogAIAssistant = (0, _log_ai_assistant.createLogAIAssistant)({
      observabilityAIAssistant
    });
    discoverShared.features.registry.register({
      id: 'observability-logs-ai-assistant',
      render: (0, _log_ai_assistant.createLogsAIAssistantRenderer)(LogAIAssistant)
    });

    // Register "Log Events" as a feature in Discover.
    // The LazySavedSearchComponent cannot be used directly because of circular dependencies
    // (see https://github.com/elastic/kibana/issues/233132).
    discoverShared.features.registry.register({
      id: 'observability-log-events',
      render: (0, _log_events.createLogEventsRenderer)({
        dataViews,
        embeddable: plugins.embeddable,
        searchSource: data.search.searchSource
      })
    });
    discoverShared.features.registry.register({
      id: 'observability-logs-fetch-document-by-id',
      fetchLogDocumentById: async (params, signal) => {
        const {
          fetchLogDocumentById
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/log/fetch_log_document_by_id')));
        return fetchLogDocumentById({
          ...params,
          data,
          logSourcesService: logsDataAccess.services.logSourcesService
        }, signal);
      }
    });
    return {
      logViews,
      LogAIAssistant,
      LogsOverview
    };
  }
  stop() {}
}
exports.LogsSharedPlugin = LogsSharedPlugin;