"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readExceptionListItemRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _zodHelpers = require("@kbn/zod-helpers");
var _api = require("@kbn/securitysolution-exceptions-common/api");
var _constants = require("@kbn/security-solution-features/constants");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const readExceptionListItemRoute = router => {
  router.versioned.get({
    access: 'public',
    path: _securitysolutionListConstants.EXCEPTION_LIST_ITEM_URL,
    security: {
      authz: {
        requiredPrivileges: [_constants.LISTS_API_READ]
      }
    }
  }).addVersion({
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_api.ReadExceptionListItemRequestQuery)
      }
    },
    version: '2023-10-31'
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const {
        id,
        item_id: itemId,
        namespace_type: namespaceType
      } = request.query;
      const exceptionLists = await (0, _utils.getExceptionListClient)(context);
      if (id == null && itemId == null) {
        return siemResponse.error({
          body: 'id or item_id required',
          statusCode: 400
        });
      }
      const exceptionListItem = await exceptionLists.getExceptionListItem({
        id,
        itemId,
        namespaceType
      });
      if (exceptionListItem == null) {
        return siemResponse.error({
          body: (0, _utils.getErrorMessageExceptionListItem)({
            id,
            itemId
          }),
          statusCode: 404
        });
      }
      return response.ok({
        body: _api.ReadExceptionListItemResponse.parse(exceptionListItem)
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.readExceptionListItemRoute = readExceptionListItemRoute;