"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRegisterFeatureRoute = registerRegisterFeatureRoute;
var _configSchema = require("@kbn/config-schema");
var _licensingTypes = require("@kbn/licensing-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRegisterFeatureRoute(router, featureUsageSetup) {
  router.post({
    path: '/internal/licensing/feature_usage/register',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization'
      }
    },
    validate: {
      body: _configSchema.schema.arrayOf(_configSchema.schema.object({
        featureId: _configSchema.schema.string(),
        licenseType: _configSchema.schema.string({
          validate: value => {
            if (!(value in _licensingTypes.LICENSE_TYPE)) {
              return `Invalid license type: ${value}`;
            }
          }
        })
      }))
    }
  }, async (context, request, response) => {
    const registrations = request.body;
    registrations.forEach(({
      featureId,
      licenseType
    }) => {
      featureUsageSetup.register(featureId, licenseType);
    });
    return response.ok({
      body: {
        success: true
      }
    });
  });
}