"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legacyPanelSchema = exports.getLensServerTransforms = void 0;
var _lensEmbeddableUtils = require("@kbn/lens-embeddable-utils");
var _configSchema = require("@kbn/config-schema");
var _transforms = require("../common/transforms");
var _content_management = require("./content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLensServerTransforms = (builder, {
  transformEnhancementsIn,
  transformEnhancementsOut
}) => {
  return {
    ...(0, _transforms.getLensTransforms)({
      builder,
      transformEnhancementsIn,
      transformEnhancementsOut
    }),
    ...getExtraServerTransformProps(builder)
  };
};
exports.getLensServerTransforms = getLensServerTransforms;
const legacyPanelSchema = exports.legacyPanelSchema = _content_management.lensItemDataSchema.extends({
  type: _configSchema.schema.maybe(_configSchema.schema.literal('lens')) // why is this added to the panel state?
});
const lensPanelSchema = _configSchema.schema.object({
  // TODO: add missing config properties
  attributes: _configSchema.schema.oneOf([_lensEmbeddableUtils.lensApiStateSchema, legacyPanelSchema])
}, {
  unknowns: 'allow'
});
function getExtraServerTransformProps(builder) {
  if (!builder.isEnabled) return {};
  return {
    schema: lensPanelSchema,
    throwOnUnmappedPanel: state => {
      const chartType = builder.getType(state.attributes);
      if (!builder.isSupported(chartType)) {
        throw new Error(`Lens "${chartType}" chart type is not supported`);
      }
    }
  };
}