"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensUpdateResponseBodySchema = exports.lensUpdateRequestQuerySchema = exports.lensUpdateRequestParamsSchema = exports.lensUpdateRequestBodySchema = void 0;
var _lodash = require("lodash");
var _configSchema = require("@kbn/config-schema");
var _config_builder = require("@kbn/lens-embeddable-utils/config_builder");
var _content_management = require("../../../../content_management");
var _v = require("../../../../content_management/v0");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lensUpdateRequestParamsSchema = exports.lensUpdateRequestParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    meta: {
      description: 'The saved object id of a Lens visualization.'
    }
  })
}, {
  unknowns: 'forbid'
});
const lensUpdateRequestQuerySchema = exports.lensUpdateRequestQuerySchema = _configSchema.schema.object({
  ...(0, _lodash.omit)(_content_management.lensCMUpdateOptionsSchema.getPropSchemas(), ['references'])
}, {
  unknowns: 'forbid'
});
const lensUpdateRequestBodySchema = exports.lensUpdateRequestBodySchema = _configSchema.schema.oneOf([_config_builder.lensApiStateSchema, _content_management.lensItemDataSchema, _v.lensItemDataSchemaV0 // Temporarily permit passing old v0 SO attributes on create
]);
const lensUpdateResponseBodySchema = exports.lensUpdateResponseBodySchema = _configSchema.schema.object({
  id: _common.lensResponseItemSchema.getPropSchemas().id,
  data: _common.lensResponseItemSchema.getPropSchemas().data,
  meta: _configSchema.schema.object({
    ..._common.lensResponseItemSchema.getPropSchemas().meta.getPropSchemas()
  }, {
    unknowns: 'forbid'
  })
}, {
  unknowns: 'forbid'
});