"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legendOptions = exports.HeatmapLegendSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _shared_components = require("../../../shared_components");
var _datasource_default_values = require("../../../shared_components/datasource_default_values");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/heatmap/toolbar_component/legend_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HeatmapLegendSettings = ({
  state,
  setState,
  frame
}) => {
  var _state$legend$shouldT;
  const legendMode = state.legend.isVisible ? 'show' : 'hide';
  const defaultTruncationValue = (0, _datasource_default_values.getDefaultVisualValuesForLayer)(state, frame.datasourceLayers).truncateText;
  const legendSize = state === null || state === void 0 ? void 0 : state.legend.legendSize;
  const [hadAutoLegendSize] = (0, _react.useState)(() => legendSize === _chartExpressionsCommon.LegendSize.AUTO);
  return /*#__PURE__*/_react.default.createElement(_shared_components.LegendSettings, {
    legendOptions: legendOptions,
    mode: legendMode,
    onDisplayChange: optionId => {
      const newMode = legendOptions.find(({
        id
      }) => id === optionId).value;
      if (newMode === 'show') {
        setState({
          ...state,
          legend: {
            ...state.legend,
            isVisible: true
          }
        });
      } else if (newMode === 'hide') {
        setState({
          ...state,
          legend: {
            ...state.legend,
            isVisible: false
          }
        });
      }
    },
    position: state === null || state === void 0 ? void 0 : state.legend.position,
    onPositionChange: id => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          position: id
        }
      });
    },
    maxLines: state === null || state === void 0 ? void 0 : state.legend.maxLines,
    onMaxLinesChange: val => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          maxLines: val
        }
      });
    },
    shouldTruncate: (_state$legend$shouldT = state === null || state === void 0 ? void 0 : state.legend.shouldTruncate) !== null && _state$legend$shouldT !== void 0 ? _state$legend$shouldT : defaultTruncationValue,
    onTruncateLegendChange: () => {
      var _state$legend$shouldT2;
      const current = (_state$legend$shouldT2 = state.legend.shouldTruncate) !== null && _state$legend$shouldT2 !== void 0 ? _state$legend$shouldT2 : defaultTruncationValue;
      setState({
        ...state,
        legend: {
          ...state.legend,
          shouldTruncate: !current
        }
      });
    },
    legendSize: legendSize,
    onLegendSizeChange: newLegendSize => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          legendSize: newLegendSize
        }
      });
    },
    showAutoLegendSizeOption: hadAutoLegendSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
};
exports.HeatmapLegendSettings = HeatmapLegendSettings;
const legendOptions = exports.legendOptions = [{
  id: `heatmap_legend_show`,
  value: 'show',
  label: _i18n.i18n.translate('xpack.lens.heatmapChart.legendVisibility.show', {
    defaultMessage: 'Show'
  })
}, {
  id: `heatmap_legend_hide`,
  value: 'hide',
  label: _i18n.i18n.translate('xpack.lens.heatmapChart.legendVisibility.hide', {
    defaultMessage: 'Hide'
  })
}];