"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableDimensionEditorAdditionalSection = TableDimensionEditorAdditionalSection;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _visualizationUtils = require("@kbn/visualization-utils");
var _summary = require("../../../../common/expressions/impl/datatable/summary");
var _utils = require("../../../../common/expressions/impl/datatable/utils");
var _datatable = require("../../../../common/expressions/defs/datatable/datatable");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/datatable/components/dimension_editor_addtional_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function updateColumnWith(state, columnId, newColumnProps) {
  return state.columns.map(currentColumn => {
    if (currentColumn.columnId === columnId) {
      return {
        ...currentColumn,
        ...newColumnProps
      };
    } else {
      return currentColumn;
    }
  });
}
function TableDimensionEditorAdditionalSection(props) {
  var _frame$activeData$sta, _frame$activeData, _frame$activeData2;
  const {
    state,
    setState,
    frame,
    accessor
  } = props;
  const column = state.columns.find(({
    columnId
  }) => accessor === columnId);
  const onSummaryLabelChangeToDebounce = (0, _react.useCallback)(newSummaryLabel => {
    setState({
      ...state,
      columns: updateColumnWith(state, accessor, {
        summaryLabel: newSummaryLabel
      })
    });
  }, [accessor, setState, state]);
  const {
    inputValue: summaryLabel,
    handleInputChange: onSummaryLabelChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    onChange: onSummaryLabelChangeToDebounce,
    value: column === null || column === void 0 ? void 0 : column.summaryLabel
  }, {
    allowFalsyValue: true
  } // falsy values are valid for this feature
  );
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!column) return null;
  if (column.isTransposed) return null;
  const currentData = (_frame$activeData$sta = (_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : _frame$activeData[state.layerId]) !== null && _frame$activeData$sta !== void 0 ? _frame$activeData$sta : (_frame$activeData2 = frame.activeData) === null || _frame$activeData2 === void 0 ? void 0 : _frame$activeData2[_datatable.DatatableInspectorTables.Default];
  const isNumeric = (0, _utils.isNumericFieldForDatatable)(currentData, accessor);
  // when switching from one operation to another, make sure to keep the configuration consistent
  const {
    summaryRow,
    summaryLabel: fallbackSummaryLabel
  } = (0, _summary.getFinalSummaryConfiguration)(accessor, column, currentData);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isNumeric && /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsIndexPatternDimensionEditor--padded lnsIndexPatternDimensionEditor--collapseNext",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
              margin-bottom: ${euiTheme.size.base};
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.lens.indexPattern.dimensionEditor.headingSummary', {
    defaultMessage: 'Summary'
  }))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.table.summaryRow.label', {
      defaultMessage: 'Summary Row'
    }),
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    compressed: true,
    isClearable: false,
    "data-test-subj": "lnsDatatable_summaryrow_function",
    placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.fieldPlaceholder', {
      defaultMessage: 'Field'
    }),
    options: (0, _summary.getSummaryRowOptions)(),
    selectedOptions: [{
      label: (0, _summary.getDefaultSummaryLabel)(summaryRow),
      value: summaryRow
    }],
    singleSelection: {
      asPlainText: true
    },
    onChange: choices => {
      const newValue = choices[0].value;
      setState({
        ...state,
        columns: updateColumnWith(state, accessor, {
          summaryRow: newValue
        })
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  })), summaryRow !== 'none' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.table.summaryRow.customlabel', {
      defaultMessage: 'Summary label'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    compressed: true,
    "data-test-subj": "lnsDatatable_summaryrow_label",
    value: summaryLabel !== null && summaryLabel !== void 0 ? summaryLabel : fallbackSummaryLabel,
    onChange: e => {
      onSummaryLabelChange(e.target.value);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 17
    }
  })))));
}