"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColorMappingTelemetryEvents = void 0;
var _lodash = require("lodash");
var _palettes = require("@kbn/palettes");
var _utils = require("@kbn/coloring/src/shared_components/color_mapping/config/utils");
var _utils2 = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COLOR_MAPPING_PREFIX = 'color_mapping_';
const getColorMappingTelemetryEvents = (colorMapping, prevColorMapping) => {
  if (!colorMapping || (0, _lodash.isEqual)(colorMapping, prevColorMapping)) {
    return [];
  }
  const {
    assignments,
    specialAssignments,
    colorMode,
    paletteId
  } = colorMapping;
  const {
    assignments: prevAssignments,
    specialAssignments: prevSpecialAssignments,
    colorMode: prevColorMode,
    paletteId: prevPaletteId
  } = prevColorMapping || {};
  const paletteData = prevPaletteId !== paletteId ? `palette_${paletteId}` : undefined;
  const gradientData = colorMode.type === 'gradient' && (prevColorMode === null || prevColorMode === void 0 ? void 0 : prevColorMode.type) !== 'gradient' ? `gradient` : undefined;
  const unassignedTermsType = getUnassignedTermsType(assignments, specialAssignments, prevSpecialAssignments);
  const diffData = [gradientData, paletteData, unassignedTermsType].filter(_utils2.nonNullable);
  if (assignments.length > 0) {
    const colorCount = assignments.length && !(0, _lodash.isEqual)(assignments, prevAssignments) ? `colors_${getRangeText(assignments.length)}` : undefined;
    const prevCustomColors = prevAssignments === null || prevAssignments === void 0 ? void 0 : prevAssignments.filter(a => a.color.type === 'colorCode');
    const customColors = assignments.filter(a => a.color.type === 'colorCode');
    const customColorEvent = customColors.length && !(0, _lodash.isEqual)(prevCustomColors, customColors) ? `custom_colors_${getRangeText(customColors.length, 1)}` : undefined;
    const avgTermsPerColor = getAvgCountTermsPerColor(assignments, prevAssignments);
    diffData.push(...[colorCount, customColorEvent, avgTermsPerColor].filter(_utils2.nonNullable));
  }
  return diffData.map(constructName);
};
exports.getColorMappingTelemetryEvents = getColorMappingTelemetryEvents;
const constructName = eventName => `${COLOR_MAPPING_PREFIX}${eventName}`;
function getRangeText(n, min = 2, max = 16) {
  if (n >= min && (n === 1 || n === 2)) {
    return String(n);
  }
  if (n <= min) {
    return `up_to_${min}`;
  } else if (n > max) {
    return `above_${max}`;
  }
  const upperBound = Math.pow(2, Math.ceil(Math.log2(n)));
  const lowerBound = upperBound / 2;
  return `${lowerBound}_to_${upperBound}`;
}
const getUnassignedTermsType = (assignments, specialAssignments, prevSpecialAssignments) => {
  const otherColor = (0, _utils.getOtherAssignmentColor)(specialAssignments, assignments);
  return !(0, _lodash.isEqual)(prevSpecialAssignments, specialAssignments) ? `unassigned_terms_${otherColor.isLoop ? 'loop' : otherColor.color.type === 'colorCode' ? 'custom' : otherColor.color.paletteId === _palettes.KbnPalette.Neutral ? _palettes.KbnPalette.Neutral : 'palette'}` : undefined;
};
const getTotalTermsCount = assignments => assignments.reduce((acc, {
  rules
}) => acc + rules.length, 0);
const getAvgCountTermsPerColor = (assignments, prevAssignments) => {
  const prevTermsCount = prevAssignments && getTotalTermsCount(prevAssignments);
  const termsCount = assignments && getTotalTermsCount(assignments);
  return termsCount && prevTermsCount !== termsCount ? `avg_count_terms_per_color_${getRangeText(termsCount / assignments.length, 1, 4)}` : undefined;
};