"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupExpressions = void 0;
var _datatable = require("../common/expressions/defs/datatable/datatable");
var _datatable_column = require("../common/expressions/impl/datatable/datatable_column");
var _map_to_columns = require("../common/expressions/defs/map_to_columns/map_to_columns");
var _format_column = require("../common/expressions/defs/format_column");
var _counter_rate = require("../common/expressions/defs/counter_rate");
var _time_scale = require("../common/expressions/defs/time_scale/time_scale");
var _collapse = require("../common/expressions/defs/collapse");
var _formula_context = require("../common/expressions/defs/formula_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setupExpressions = (expressions, formatFactory, getDatatableUtilities, getTimeZone, getForceNow) => {
  [_formula_context.formulaTimeRangeFn, _formula_context.formulaNowFn, _formula_context.formulaIntervalFn, _collapse.collapse, _counter_rate.counterRate, _format_column.formatColumn, _map_to_columns.mapToColumns, _datatable_column.datatableColumn, (0, _datatable.getDatatable)(formatFactory), (0, _time_scale.getTimeScale)(getDatatableUtilities, getTimeZone, getForceNow)].forEach(expressionFn => expressions.registerFunction(expressionFn));
};
exports.setupExpressions = setupExpressions;