"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onDropForVisualization = onDropForVisualization;
var _types_guards = require("../../../../types_guards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function onDropForVisualization(props, activeVisualization) {
  const {
    prevState,
    target,
    frame,
    source,
    group,
    dropType
  } = props;
  const {
    layerId,
    columnId,
    groupId
  } = target;
  const previousColumn = (0, _types_guards.isOperation)(source) && group !== null && group !== void 0 && group.requiresPreviousColumnOnDuplicate ? source.columnId : undefined;
  let newVisState = activeVisualization.setDimension({
    columnId,
    groupId,
    layerId,
    prevState,
    previousColumn,
    frame
  });
  if ((0, _types_guards.isOperation)(source) && (dropType === 'move_compatible' || dropType === 'move_incompatible' || dropType === 'combine_incompatible' || dropType === 'combine_compatible' || dropType === 'replace_compatible' || dropType === 'replace_incompatible')) newVisState = activeVisualization.removeDimension({
    layerId: source.layerId,
    columnId: source.columnId,
    prevState: newVisState,
    frame
  });
  return newVisState;
}