"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dateHistogramOperation = void 0;
exports.mapToEsqlInterval = mapToEsqlInterval;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _public2 = require("@kbn/expressions-plugin/public");
var _visualizationUtils = require("@kbn/visualization-utils");
var _esqlUtils = require("@kbn/esql-utils");
var _layer_helpers = require("../layer_helpers");
var _helpers = require("./helpers");
var _user_messages_ids = require("../../../../user_messages_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/operations/definitions/date_histogram.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  isValidInterval
} = _public.search.aggs;
const autoInterval = 'auto';
const calendarOnlyIntervals = new Set(['w', 'M', 'q', 'y']);
function getMultipleDateHistogramsErrorMessage(layer, columnId) {
  const usesTimeShift = Object.values(layer.columns).some(col => col.timeShift && col.timeShift !== '');
  if (!usesTimeShift) {
    return [];
  }
  const dateHistograms = layer.columnOrder.filter(colId => layer.columns[colId].operationType === 'date_histogram');
  if (dateHistograms.length < 2) {
    return [];
  }
  return [{
    uniqueId: _user_messages_ids.TIME_SHIFT_MULTIPLE_DATE_HISTOGRAMS,
    message: _i18n.i18n.translate('xpack.lens.indexPattern.multipleDateHistogramsError', {
      defaultMessage: '"{dimensionLabel}" is not the only date histogram. When using time shifts, make sure to only use one date histogram.',
      values: {
        dimensionLabel: layer.columns[columnId].label
      }
    })
  }];
}
function getTimeZoneAndInterval(column, indexPattern) {
  var _column$params$interv, _column$params;
  const usedField = indexPattern.getFieldByName(column.sourceField);
  if (usedField && usedField.aggregationRestrictions && usedField.aggregationRestrictions.date_histogram) {
    var _restrictedInterval;
    return {
      interval: (_restrictedInterval = restrictedInterval(usedField.aggregationRestrictions)) !== null && _restrictedInterval !== void 0 ? _restrictedInterval : autoInterval,
      timeZone: usedField.aggregationRestrictions.date_histogram.time_zone,
      usedField
    };
  }
  return {
    usedField: undefined,
    timeZone: undefined,
    interval: (_column$params$interv = (_column$params = column.params) === null || _column$params === void 0 ? void 0 : _column$params.interval) !== null && _column$params$interv !== void 0 ? _column$params$interv : autoInterval
  };
}
function mapToEsqlInterval(dateRange, interval) {
  if (interval !== 'm' && interval.endsWith('m')) {
    return interval.replace('m', ' minutes');
  }
  switch (interval) {
    case '1M':
      return '1 month';
    case 'd':
      return '1d';
    case 'h':
      return '1h';
    case 'm':
      return '1 minute';
    case 's':
      return '1s';
    case 'ms':
      return '1ms';
    default:
      return interval;
  }
}
const dateHistogramOperation = exports.dateHistogramOperation = {
  type: 'date_histogram',
  displayName: _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram', {
    defaultMessage: 'Date histogram'
  }),
  input: 'field',
  priority: 5,
  // Highest priority level used
  scale: () => 'interval',
  operationParams: [{
    name: 'interval',
    type: 'string',
    required: false
  }],
  getErrorMessage: (layer, columnId, indexPattern) => [...(0, _helpers.getInvalidFieldMessage)(layer, columnId, indexPattern), ...getMultipleDateHistogramsErrorMessage(layer, columnId)],
  getPossibleOperationForField: ({
    aggregationRestrictions,
    aggregatable,
    type
  }) => {
    if ((type === 'date' || type === 'date_range') && aggregatable && (!aggregationRestrictions || aggregationRestrictions.date_histogram)) {
      return {
        dataType: 'date',
        isBucketed: true,
        scale: 'interval'
      };
    }
  },
  getDefaultLabel: (column, columns, indexPattern, uiSettings, dateRange) => {
    var _column$params2;
    const field = (0, _helpers.getSafeName)(column.sourceField, indexPattern);
    let interval = ((_column$params2 = column.params) === null || _column$params2 === void 0 ? void 0 : _column$params2.interval) || autoInterval;
    if (dateRange && uiSettings) {
      var _calcAutoInterval;
      const calcAutoInterval = (0, _common.getCalculateAutoTimeExpression)(key => uiSettings.get(key));
      interval = ((_calcAutoInterval = calcAutoInterval({
        from: dateRange.fromDate,
        to: dateRange.toDate
      }, interval, false)) === null || _calcAutoInterval === void 0 ? void 0 : _calcAutoInterval.description) || 'hour';
      return _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.interval', {
        defaultMessage: `{field} per {interval}`,
        values: {
          field: field || '',
          interval
        }
      });
    }
    return field;
  },
  buildColumn({
    field
  }, columnParams) {
    var _columnParams$interva, _columnParams$include;
    return {
      label: field.displayName,
      dataType: 'date',
      operationType: 'date_histogram',
      sourceField: field.name,
      isBucketed: true,
      params: {
        interval: (_columnParams$interva = columnParams === null || columnParams === void 0 ? void 0 : columnParams.interval) !== null && _columnParams$interva !== void 0 ? _columnParams$interva : autoInterval,
        includeEmptyRows: (_columnParams$include = columnParams === null || columnParams === void 0 ? void 0 : columnParams.includeEmptyRows) !== null && _columnParams$include !== void 0 ? _columnParams$include : true,
        dropPartials: Boolean(columnParams === null || columnParams === void 0 ? void 0 : columnParams.dropPartials)
      }
    };
  },
  isTransferable: (column, newIndexPattern) => {
    const newField = newIndexPattern.getFieldByName(column.sourceField);
    return Boolean(newField && newField.type === 'date' && newField.aggregatable && (!newField.aggregationRestrictions || newField.aggregationRestrictions.date_histogram));
  },
  onFieldChange: (oldColumn, field) => {
    return {
      ...oldColumn,
      label: field.displayName,
      sourceField: field.name
    };
  },
  getSerializedFormat: (column, targetColumn, indexPattern, uiSettings, dateRange) => {
    var _calcAutoInterval2;
    if (!indexPattern || !dateRange || !uiSettings) return {
      id: 'date'
    };
    const {
      interval
    } = getTimeZoneAndInterval(column, indexPattern);
    const calcAutoInterval = (0, _common.getCalculateAutoTimeExpression)(key => uiSettings.get(key));
    const usedInterval = ((_calcAutoInterval2 = calcAutoInterval({
      from: dateRange.fromDate,
      to: dateRange.toDate
    }, interval, false)) === null || _calcAutoInterval2 === void 0 ? void 0 : _calcAutoInterval2.asMilliseconds()) || 3600000;
    const rules = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get('dateFormat:scaled');
    for (let i = rules.length - 1; i >= 0; i--) {
      const rule = rules[i];
      if (!Array.isArray(rule) || rule.length !== 2) continue;
      if (!rule[0] || usedInterval && usedInterval >= _moment.default.duration(rule[0]).asMilliseconds()) {
        return {
          id: 'date',
          params: {
            pattern: rule[1]
          }
        };
      }
    }
    return {
      id: 'date',
      params: {
        pattern: uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get('dateFormat')
      }
    };
  },
  toESQL: (column, columnId, indexPattern, layer, uiSettings, dateRange) => {
    var _column$params3;
    if ((_column$params3 = column.params) !== null && _column$params3 !== void 0 && _column$params3.includeEmptyRows) return;
    const {
      interval
    } = getTimeZoneAndInterval(column, indexPattern);
    const calcAutoInterval = (0, _common.getCalculateAutoTimeExpression)(key => uiSettings.get(key));
    if (interval === 'auto') {
      return `BUCKET(${(0, _esqlUtils.sanitazeESQLInput)(column.sourceField)}, ${mapToEsqlInterval(dateRange, calcAutoInterval({
        from: dateRange.fromDate,
        to: dateRange.toDate
      }) || '1h')})`;
    }
    return `BUCKET(${(0, _esqlUtils.sanitazeESQLInput)(column.sourceField)}, ${mapToEsqlInterval(dateRange, interval)})`;
  },
  toEsAggsFn: (column, columnId, indexPattern) => {
    var _column$params4, _column$params5, _usedField$aggregatio, _column$params6, _column$params7;
    const {
      usedField,
      timeZone,
      interval
    } = getTimeZoneAndInterval(column, indexPattern);
    const dropPartials = Boolean(((_column$params4 = column.params) === null || _column$params4 === void 0 ? void 0 : _column$params4.dropPartials) && (
    // set to false when detached from time picker
    indexPattern.timeFieldName === (usedField === null || usedField === void 0 ? void 0 : usedField.name) || !((_column$params5 = column.params) !== null && _column$params5 !== void 0 && _column$params5.ignoreTimeRange)));
    return (0, _public2.buildExpressionFunction)('aggDateHistogram', {
      id: columnId,
      enabled: true,
      schema: 'segment',
      field: column.sourceField,
      time_zone: timeZone,
      useNormalizedEsInterval: !(usedField !== null && usedField !== void 0 && (_usedField$aggregatio = usedField.aggregationRestrictions) !== null && _usedField$aggregatio !== void 0 && _usedField$aggregatio.date_histogram),
      interval,
      drop_partials: dropPartials,
      min_doc_count: (_column$params6 = column.params) !== null && _column$params6 !== void 0 && _column$params6.includeEmptyRows ? 0 : 1,
      extended_bounds: (0, _common.extendedBoundsToAst)({}),
      extendToTimeRange: (_column$params7 = column.params) === null || _column$params7 === void 0 ? void 0 : _column$params7.includeEmptyRows
    }).toAst();
  },
  paramEditor: function ParamEditor({
    layer,
    columnId,
    currentColumn,
    paramEditorUpdater,
    dateRange,
    data,
    indexPattern
  }) {
    const field = currentColumn && indexPattern.getFieldByName(currentColumn.sourceField);
    const intervalIsRestricted = field.aggregationRestrictions && field.aggregationRestrictions.date_histogram;
    const [intervalInput, setIntervalInput] = (0, _react.useState)(currentColumn.params.interval);
    const interval = intervalInput === autoInterval ? autoInterval : parseInterval(intervalInput);

    // We force the interval value to 1 if it's empty, since that is the ES behavior,
    // and the isValidInterval function doesn't handle the empty case properly. Fixing
    // isValidInterval involves breaking changes in other areas.
    const isValid = !currentColumn.params.ignoreTimeRange && intervalInput === autoInterval || interval !== autoInterval && intervalInput !== '' && isValidInterval(`${interval.value === '' ? '1' : interval.value}${interval.unit}`, restrictedInterval(field.aggregationRestrictions));
    const onChangeDropPartialBuckets = (0, _react.useCallback)(ev => {
      // updateColumnParam will be called async
      // store the checked value before the event pooling clears it
      const value = ev.target.checked;
      paramEditorUpdater(newLayer => (0, _layer_helpers.updateColumnParam)({
        layer: newLayer,
        columnId,
        paramName: 'dropPartials',
        value
      }));
    }, [columnId, paramEditorUpdater]);
    const setInterval = (0, _react.useCallback)(newInterval => {
      const isCalendarInterval = newInterval !== autoInterval && calendarOnlyIntervals.has(newInterval.unit);
      const value = newInterval === autoInterval ? autoInterval : `${isCalendarInterval ? '1' : newInterval.value}${newInterval.unit || 'd'}`;
      paramEditorUpdater(newLayer => (0, _layer_helpers.updateColumnParam)({
        layer: newLayer,
        columnId,
        paramName: 'interval',
        value
      }));
    }, [columnId, paramEditorUpdater]);
    const options = (_common.intervalOptions || []).filter(option => option.val !== autoInterval).map(option => {
      return {
        label: option.display,
        key: option.val
      };
    }, []);
    options.unshift({
      label: _i18n.i18n.translate('xpack.lens.indexPattern.autoIntervalLabel', {
        defaultMessage: 'Auto ({interval})',
        values: {
          interval: data.search.aggs.calculateAutoTimeExpression({
            from: dateRange.fromDate,
            to: dateRange.toDate
          }) || '1h'
        }
      }),
      key: autoInterval
    });
    const definedOption = options.find(o => o.key === intervalInput);
    const selectedOptions = definedOption ? [definedOption] : [{
      label: intervalInput,
      key: intervalInput
    }];
    (0, _react.useEffect)(() => {
      if (isValid && intervalInput !== currentColumn.params.interval) {
        setInterval(parseInterval(intervalInput));
      }
    }, [intervalInput, isValid, currentColumn.params.interval, setInterval]);
    const bindToGlobalTimePickerValue = indexPattern.timeFieldName === (field === null || field === void 0 ? void 0 : field.name) || !currentColumn.params.ignoreTimeRange;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 366,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "rowCompressed",
      hasChildLabel: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 367,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 370,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.includeEmptyRows', {
        defaultMessage: 'Include empty rows'
      })),
      checked: Boolean(currentColumn.params.includeEmptyRows),
      "data-test-subj": "indexPattern-include-empty-rows",
      onChange: () => {
        paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
          layer,
          columnId,
          paramName: 'includeEmptyRows',
          value: !currentColumn.params.includeEmptyRows
        }));
      },
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 368,
        columnNumber: 11
      }
    })), indexPattern.timeFieldName !== (field === null || field === void 0 ? void 0 : field.name) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 393,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "rowCompressed",
      hasChildLabel: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 394,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 397,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.bindToGlobalTimePicker', {
        defaultMessage: 'Bind to global time picker'
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        color: "subdued",
        content: _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.globalTimePickerHelp', {
          defaultMessage: "Filter the selected field by the global time picker in the top right. This setting can't be turned off for the default time field of the current data view."
        }),
        iconProps: {
          className: 'eui-alignTop'
        },
        position: "top",
        size: "s",
        type: "question",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 404,
          columnNumber: 21
        }
      })),
      disabled: indexPattern.timeFieldName === (field === null || field === void 0 ? void 0 : field.name),
      checked: bindToGlobalTimePickerValue,
      onChange: () => {
        let newLayer = (0, _layer_helpers.updateColumnParam)({
          layer,
          columnId,
          paramName: 'ignoreTimeRange',
          value: !currentColumn.params.ignoreTimeRange
        });
        if (!currentColumn.params.ignoreTimeRange && currentColumn.params.interval === autoInterval) {
          const newFixedInterval = data.search.aggs.calculateAutoTimeExpression({
            from: dateRange.fromDate,
            to: dateRange.toDate
          }) || '1h';
          newLayer = (0, _layer_helpers.updateColumnParam)({
            layer: newLayer,
            columnId,
            paramName: 'interval',
            value: newFixedInterval
          });
          setIntervalInput(newFixedInterval);
        }
        paramEditorUpdater(newLayer);
      },
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 395,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.minimumInterval', {
        defaultMessage: 'Minimum interval'
      }),
      fullWidth: true,
      display: "rowCompressed",
      helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.selectOptionHelpText', {
        defaultMessage: `Select an option or create a custom value.`
      }), /*#__PURE__*/_react.default.createElement("br", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 466,
          columnNumber: 15
        }
      }), _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.selectOptionExamplesHelpText', {
        defaultMessage: `Examples: 30s, 20m, 24h, 2d, 1w, 1M`
      })),
      isInvalid: !isValid,
      error: !isValid && _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.invalidInterval', {
        defaultMessage: "Please pick a valid interval. It's not possible to use multiple weeks, months or years as interval."
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 455,
        columnNumber: 9
      }
    }, intervalIsRestricted ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.indexPattern.dateHistogram.restrictedInterval",
      defaultMessage: "Interval fixed to {intervalValue} due to aggregation restrictions.",
      values: {
        intervalValue: restrictedInterval(field.aggregationRestrictions)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 485,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      compressed: true,
      fullWidth: true,
      "data-test-subj": "lensDateHistogramInterval",
      isInvalid: !isValid,
      onChange: opts => {
        const newValue = opts.length ? opts[0].key : '';
        setIntervalInput(newValue);
        if (newValue === autoInterval && currentColumn.params.ignoreTimeRange) {
          paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
            layer,
            columnId,
            paramName: 'ignoreTimeRange',
            value: false
          }));
        }
      },
      onCreateOption: customValue => setIntervalInput(customValue.trim()),
      options: options,
      selectedOptions: selectedOptions,
      singleSelection: {
        asPlainText: true
      },
      placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.selectIntervalPlaceholder', {
        defaultMessage: 'Select an interval'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 493,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 525,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "rowCompressed",
      hasChildLabel: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 526,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
      tooltipContent: _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.dropPartialBucketsHelp', {
        defaultMessage: 'Drop partial intervals is disabled as these can be computed only for a time field bound to global time picker in the top right.'
      }),
      condition: !bindToGlobalTimePickerValue,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 527,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 539,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.dropPartialBuckets', {
        defaultMessage: 'Drop partial intervals'
      })),
      "data-test-subj": "lensDropPartialIntervals",
      checked: Boolean(currentColumn.params.dropPartials),
      onChange: onChangeDropPartialBuckets,
      compressed: true,
      disabled: !bindToGlobalTimePickerValue,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 537,
        columnNumber: 13
      }
    }))));
  },
  helpComponentTitle: _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.titleHelp', {
    defaultMessage: 'How Date histogram works'
  }),
  helpComponent() {
    const infiniteBound = _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.moreThanYear', {
      defaultMessage: 'More than a year'
    });
    const upToLabel = _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.upTo', {
      defaultMessage: 'Up to'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 569,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.autoBasicExplanation', {
      defaultMessage: 'Date histogram splits data into time intervals.'
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 575,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.indexPattern.dateHistogram.autoLongerExplanation",
      defaultMessage: "To choose the interval, Lens divides the specified time range by the {targetBarSetting} Advanced Setting and calculates the best interval for your data. For example, when the time range is 4 days, the data is divided into hourly buckets. To configure the maximum number of bars, use the {maxBarSetting} Advanced Setting.",
      values: {
        maxBarSetting: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 580,
            columnNumber: 30
          }
        }, _public.UI_SETTINGS.HISTOGRAM_MAX_BARS),
        targetBarSetting: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 581,
            columnNumber: 33
          }
        }, _public.UI_SETTINGS.HISTOGRAM_BAR_TARGET)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 576,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 586,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.autoAdvancedExplanation', {
      defaultMessage: 'The interval follows this logic:'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      items: _public.search.aggs.boundsDescendingRaw.map(({
        bound,
        boundLabel,
        intervalLabel
      }) => ({
        bound: typeof bound === 'number' ? infiniteBound : `${upToLabel} ${boundLabel}`,
        interval: intervalLabel
      })),
      columns: [{
        field: 'bound',
        name: _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.autoBoundHeader', {
          defaultMessage: 'Target interval measured'
        })
      }, {
        field: 'interval',
        name: _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.autoIntervalHeader', {
          defaultMessage: 'Interval used'
        })
      }],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 592,
        columnNumber: 9
      }
    }));
  },
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.dateHistogram.documentation.quick', {
    defaultMessage: `
The date or date range values distributed into intervals.
      `
  })
};
function parseInterval(currentInterval) {
  const interval = currentInterval || '';
  const valueMatch = interval.match(/[\d]+/) || [];
  const unitMatch = interval.match(/[\D]+/) || [];
  const result = parseInt(valueMatch[0] || '', 10);
  return {
    value: isNaN(result) ? '' : result,
    unit: unitMatch[0] || 'h'
  };
}
function restrictedInterval(aggregationRestrictions) {
  if (!aggregationRestrictions || !aggregationRestrictions.date_histogram) {
    return;
  }
  return aggregationRestrictions.date_histogram.calendar_interval || aggregationRestrictions.date_histogram.fixed_interval;
}