"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromCumulativeSumLensStateToAPI = exports.fromCumulativeSumAPItoLensState = void 0;
var _format = require("./format");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fromCumulativeSumAPItoLensState = (options, ref) => {
  const {
    format
  } = options;
  return {
    operationType: 'cumulative_sum',
    references: [ref.id],
    ...(0, _utils.getLensStateMetricSharedProps)(options),
    params: {
      ...(format ? {
        format: (0, _format.fromFormatAPIToLensState)(format)
      } : {})
    }
  };
};
exports.fromCumulativeSumAPItoLensState = fromCumulativeSumAPItoLensState;
const fromCumulativeSumLensStateToAPI = (options, ref) => {
  var _options$params;
  return {
    operation: 'cumulative_sum',
    field: ref.field,
    ...(0, _utils.getLensAPIMetricSharedProps)(options),
    ...((_options$params = options.params) !== null && _options$params !== void 0 && _options$params.format ? {
      format: (0, _format.fromFormatLensStateToAPI)(options.params.format)
    } : {})
  };
};
exports.fromCumulativeSumLensStateToAPI = fromCumulativeSumLensStateToAPI;