"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromColorByValueAPIToLensState = fromColorByValueAPIToLensState;
exports.fromColorByValueLensStateToAPI = fromColorByValueLensStateToAPI;
exports.fromColorMappingAPIToLensState = fromColorMappingAPIToLensState;
exports.fromColorMappingLensStateToAPI = fromColorMappingLensStateToAPI;
exports.fromStaticColorAPIToLensState = fromStaticColorAPIToLensState;
exports.fromStaticColorLensStateToAPI = fromStaticColorLensStateToAPI;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LENS_COLOR_BY_VALUE_RANGE_TYPE = 'absolute';
const LENS_DEFAULT_COLOR_MAPPING_PALETTE = 'default';
const LEGACY_TO_API_RANGE_NAMES = {
  number: 'absolute',
  percent: 'percentage'
};
const API_TO_LEGACY_RANGE_NAMES = {
  absolute: 'number',
  percentage: 'percent'
};
function fromColorByValueAPIToLensState(color) {
  if (!color) {
    return;
  }
  const stops = color.steps.map(step => {
    if (step.type === 'from') {
      return {
        color: step.color,
        stop: step.from
      };
    }
    if (step.type === 'to') {
      return {
        color: step.color,
        stop: step.to
      };
    }
    return {
      color: step.color,
      stop: step.value
    };
  });
  return {
    type: 'palette',
    name: 'custom',
    params: {
      name: 'custom',
      ...(color.range === 'percentage' ? {
        rangeMin: color.min,
        rangeMax: color.max
      } : {}),
      rangeType: color.range ? API_TO_LEGACY_RANGE_NAMES[color.range] : API_TO_LEGACY_RANGE_NAMES.absolute,
      stops,
      colorStops: stops
    }
  };
}
function fromColorByValueLensStateToAPI(color) {
  var _color$params$stops$m2, _color$params$stops3;
  if (!color || !color.params) {
    return;
  }
  const rangeType = color.params.rangeType ? LEGACY_TO_API_RANGE_NAMES[color.params.rangeType] : LENS_COLOR_BY_VALUE_RANGE_TYPE;
  if (rangeType === 'absolute') {
    var _color$params$stops$m, _color$params$stops;
    return {
      type: 'dynamic',
      range: rangeType,
      steps: (_color$params$stops$m = (_color$params$stops = color.params.stops) === null || _color$params$stops === void 0 ? void 0 : _color$params$stops.map((step, index) => {
        var _color$params$stops$l, _color$params, _color$params$stops2;
        const isFirst = index === 0;
        if (isFirst) {
          return {
            type: 'from',
            color: step.color,
            from: step.stop
          };
        }
        const isLast = index === ((_color$params$stops$l = (_color$params = color.params) === null || _color$params === void 0 ? void 0 : (_color$params$stops2 = _color$params.stops) === null || _color$params$stops2 === void 0 ? void 0 : _color$params$stops2.length) !== null && _color$params$stops$l !== void 0 ? _color$params$stops$l : 0) - 1;
        if (isLast) {
          return {
            type: 'to',
            color: step.color,
            to: step.stop
          };
        }
        return {
          type: 'exact',
          color: step.color,
          value: step.stop
        };
      })) !== null && _color$params$stops$m !== void 0 ? _color$params$stops$m : []
    };
  }
  return {
    type: 'dynamic',
    min: color.params.rangeMin,
    max: color.params.rangeMax,
    range: rangeType,
    steps: (_color$params$stops$m2 = (_color$params$stops3 = color.params.stops) === null || _color$params$stops3 === void 0 ? void 0 : _color$params$stops3.map((step, index) => {
      var _color$params$stops$l2, _color$params2, _color$params2$stops;
      const isFirst = index === 0;
      if (isFirst) {
        return {
          type: 'from',
          color: step.color,
          from: step.stop
        };
      }
      const isLast = index === ((_color$params$stops$l2 = (_color$params2 = color.params) === null || _color$params2 === void 0 ? void 0 : (_color$params2$stops = _color$params2.stops) === null || _color$params2$stops === void 0 ? void 0 : _color$params2$stops.length) !== null && _color$params$stops$l2 !== void 0 ? _color$params$stops$l2 : 0) - 1;
      if (isLast) {
        return {
          type: 'to',
          color: step.color,
          to: step.stop
        };
      }
      return {
        type: 'exact',
        color: step.color,
        value: step.stop
      };
    })) !== null && _color$params$stops$m2 !== void 0 ? _color$params$stops$m2 : []
  };
}
function fromStaticColorLensStateToAPI(color) {
  if (!color) {
    return;
  }
  return {
    type: 'static',
    color
  };
}
function fromStaticColorAPIToLensState(color) {
  if (!color) {
    return;
  }
  return {
    color: color.color
  };
}
function fromColorLensStateToAPI(color) {
  if (color.type === 'colorCode') {
    return {
      type: 'colorCode',
      value: color.colorCode
    };
  }
  return {
    type: 'from_palette',
    palette: color.paletteId,
    index: color.colorIndex
  };
}
function fromRulesLensStateToAPI(rules) {
  return rules.filter(rule => rule.type === 'raw').map(rule => rule.value);
}
function isLensStateCategoricalConfigColorMapping(colorMapping) {
  return colorMapping.colorMode.type === 'categorical';
}
function fromUnassignedColorLensStateToAPI(color) {
  if (!color || color.type === 'loop') {
    return {};
  }
  const unassignedColor = fromColorLensStateToAPI(color);
  if (unassignedColor.type === 'from_palette') {
    return {};
  }
  return {
    unassignedColor
  };
}
function fromColorMappingLensStateToAPI(colorMapping) {
  var _colorMapping$special;
  if (!colorMapping) {
    return;
  }
  const unassignedColor = fromUnassignedColorLensStateToAPI((_colorMapping$special = colorMapping.specialAssignments[0]) === null || _colorMapping$special === void 0 ? void 0 : _colorMapping$special.color);
  if (isLensStateCategoricalConfigColorMapping(colorMapping)) {
    return {
      mode: 'categorical',
      palette: colorMapping.paletteId,
      mapping: colorMapping.assignments.map(({
        rules,
        color
      }) => {
        return {
          values: fromRulesLensStateToAPI(rules),
          color: fromColorLensStateToAPI(color)
        };
      }),
      ...unassignedColor
    };
  }
  const colorAssignments = colorMapping.assignments.filter(assignment => assignment.color.type !== 'gradient');
  return {
    mode: 'gradient',
    palette: colorMapping.paletteId,
    mapping: colorAssignments.map(({
      rules
    }) => {
      return {
        values: fromRulesLensStateToAPI(rules)
      };
    }),
    gradient: colorAssignments.map(({
      color
    }) => fromColorLensStateToAPI(color)),
    ...unassignedColor
  };
}
function fromColorDefAPIToLensState(color) {
  var _color$palette;
  if (color.type === 'colorCode') {
    return {
      type: 'colorCode',
      colorCode: color.value
    };
  }
  return {
    type: 'categorical',
    paletteId: (_color$palette = color.palette) !== null && _color$palette !== void 0 ? _color$palette : LENS_DEFAULT_COLOR_MAPPING_PALETTE,
    colorIndex: color.index
  };
}
function fromRulesAPIToLensState(values) {
  return values.map(value => {
    return {
      type: 'raw',
      value
    };
  });
}
function isAPICategoricalConfigColorMapping(colorMapping) {
  return colorMapping.mode === 'categorical';
}
function fromAPIMappingToAssignments(colorMapping) {
  if (!colorMapping || !colorMapping.mapping) {
    return [];
  }
  if (isAPICategoricalConfigColorMapping(colorMapping)) {
    return colorMapping.mapping.map(assignment => {
      return {
        rules: fromRulesAPIToLensState(assignment.values),
        color: fromColorDefAPIToLensState(assignment.color),
        touched: false
      };
    });
  }
  return colorMapping.mapping.map((assignment, index) => {
    var _colorMapping$gradien;
    const step = (_colorMapping$gradien = colorMapping.gradient) === null || _colorMapping$gradien === void 0 ? void 0 : _colorMapping$gradien[index];
    return {
      rules: fromRulesAPIToLensState(assignment.values),
      color: fromColorDefAPIToLensState(step),
      touched: false
    };
  });
}
function fromColorMappingAPIToLensState(colorMapping) {
  var _colorMapping$gradien2, _colorMapping$gradien3;
  if (!colorMapping) {
    return;
  }
  const specialAssignments = [{
    rules: [{
      type: 'other'
    }],
    color: colorMapping.unassignedColor ? {
      type: 'colorCode',
      colorCode: colorMapping.unassignedColor.value
    } : {
      type: 'loop'
    },
    touched: false
  }];
  const assignments = fromAPIMappingToAssignments(colorMapping);
  const colorMode = colorMapping.mode !== 'gradient' ? {
    type: colorMapping.mode
  } : {
    type: colorMapping.mode,
    steps: ((_colorMapping$gradien2 = (_colorMapping$gradien3 = colorMapping.gradient) === null || _colorMapping$gradien3 === void 0 ? void 0 : _colorMapping$gradien3.map(fromColorDefAPIToLensState)) !== null && _colorMapping$gradien2 !== void 0 ? _colorMapping$gradien2 : []).map(step => ({
      ...step,
      touched: false
    })),
    // in the conversion we've lost the actual sort order, so default to "asc"
    sort: 'asc'
  };
  return {
    colorMode,
    paletteId: colorMapping.palette,
    assignments,
    specialAssignments
  };
}