"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatTypeSchema = exports.formatSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const numericFormatSchema = _configSchema.schema.object({
  type: _configSchema.schema.oneOf([_configSchema.schema.literal('number'), _configSchema.schema.literal('percent')]),
  /**
   * Number of decimals
   */
  decimals: _configSchema.schema.number({
    defaultValue: _constants.LENS_FORMAT_NUMBER_DECIMALS_DEFAULT,
    meta: {
      description: 'Number of decimals'
    }
  }),
  /**
   * Suffix
   */
  suffix: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Suffix'
    }
  })),
  /**
   * Whether to use compact notation
   */
  compact: _configSchema.schema.boolean({
    defaultValue: _constants.LENS_FORMAT_COMPACT_DEFAULT,
    meta: {
      description: 'Whether to use compact notation'
    }
  })
});
const byteFormatSchema = _configSchema.schema.object({
  type: _configSchema.schema.oneOf([_configSchema.schema.literal('bits'), _configSchema.schema.literal('bytes')]),
  /**
   * Number of decimals
   */
  decimals: _configSchema.schema.number({
    defaultValue: _constants.LENS_FORMAT_NUMBER_DECIMALS_DEFAULT,
    meta: {
      description: 'Number of decimals'
    }
  }),
  /**
   * Suffix
   */
  suffix: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Suffix'
    }
  }))
});
const durationFormatSchema = _configSchema.schema.object({
  type: _configSchema.schema.literal('duration'),
  /**
   * From
   */
  from: _configSchema.schema.string({
    meta: {
      description: 'From'
    }
  }),
  /**
   * To
   */
  to: _configSchema.schema.string({
    meta: {
      description: 'To'
    }
  }),
  /**
   * Suffix
   */
  suffix: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Suffix'
    }
  }))
});
const customFormatSchema = _configSchema.schema.object({
  type: _configSchema.schema.literal('custom'),
  /**
   * Pattern
   */
  pattern: _configSchema.schema.string({
    meta: {
      description: 'Pattern'
    }
  })
});

/**
 * Format configuration
 */
const formatTypeSchema = exports.formatTypeSchema = _configSchema.schema.oneOf([numericFormatSchema, byteFormatSchema, durationFormatSchema, customFormatSchema]);
const formatSchema = exports.formatSchema = {
  /**
   * Format configuration
   */
  format: _configSchema.schema.maybe(formatTypeSchema)
};