"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mosaicStateSchemaNoESQL = exports.mosaicStateSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _metric_ops = require("../metric_ops");
var _color = require("../color");
var _dataset = require("../dataset");
var _shared = require("../shared");
var _partition_shared = require("./partition_shared");
var _shared2 = require("./shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const mosaicStateSharedSchema = {
  legend: _configSchema.schema.maybe(_configSchema.schema.object({
    nested: _partition_shared.legendNestedSchema,
    truncate_after_lines: _partition_shared.legendTruncateAfterLinesSchema,
    visible: _partition_shared.legendVisibleSchema,
    size: _partition_shared.legendSizeSchema
  }, {
    meta: {
      description: 'Legend configuration for mosaic chart appearance and behavior'
    }
  })),
  value_display: _partition_shared.valueDisplaySchema
};
const partitionStatePrimaryMetricOptionsSchema = _configSchema.schema.object({
  /**
   * Color configuration
   */
  color: _configSchema.schema.maybe(_color.staticColorSchema)
}, {
  meta: {
    description: 'Configuration options for primary metric values in a mosaic partition, including static color settings'
  }
});
const partitionStateBreakdownByOptionsSchema = _configSchema.schema.object({
  /**
   * Color configuration: static color, color by value, or color mapping
   */
  color: _configSchema.schema.maybe(_configSchema.schema.oneOf([_color.colorByValueSchema, _color.colorMappingSchema], {
    meta: {
      description: 'Color configuration: by value (palette-based) or mapping (custom rules)'
    }
  })),
  /**
   * Collapse by function. This parameter is used to collapse the
   * metric chart when the number of columns is bigger than the
   * number of columns specified in the columns parameter.
   * Possible values:
   * - 'avg': Collapse by average
   * - 'sum': Collapse by sum
   * - 'max': Collapse by max
   * - 'min': Collapse by min
   * - 'none': Do not collapse
   */
  collapse_by: _configSchema.schema.maybe(_shared.collapseBySchema)
}, {
  meta: {
    description: 'Configuration options for breakdown dimensions in a mosaic partition, including color settings and collapse behavior'
  }
});
function validateMosaicGroupings(obj) {
  var _obj$inner_grouping$f, _obj$inner_grouping;
  if (obj.outer_grouping.filter(def => def.collapse_by == null).length > 1) {
    return 'In outer grouping, only a single non-collapsed dimension is allowed when using multiple dimensions.';
  }
  if (((_obj$inner_grouping$f = (_obj$inner_grouping = obj.inner_grouping) === null || _obj$inner_grouping === void 0 ? void 0 : _obj$inner_grouping.filter(def => def.collapse_by == null).length) !== null && _obj$inner_grouping$f !== void 0 ? _obj$inner_grouping$f : 0) > 1) {
    return 'In inner grouping, only a single non-collapsed dimension is allowed when using multiple dimensions.';
  }
}
const mosaicStateSchemaNoESQL = exports.mosaicStateSchemaNoESQL = _configSchema.schema.object({
  type: _configSchema.schema.literal('mosaic'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetSchema,
  ...mosaicStateSharedSchema,
  /**
   * Primary value configuration, must define operation. Supports field-based operations (count, unique count, metrics, sum, last value, percentile, percentile ranks), reference-based operations (differences, moving average, cumulative sum, counter rate), and formula-like operations (static value, formula).
   */
  metric: (0, _shared2.mergeAllMetricsWithChartDimensionSchemaWithRefBasedOps)(partitionStatePrimaryMetricOptionsSchema),
  outer_grouping: _configSchema.schema.arrayOf((0, _shared2.mergeAllBucketsWithChartDimensionSchema)(partitionStateBreakdownByOptionsSchema), {
    minSize: 1,
    meta: {
      description: 'Array of vertical grouping dimensions: it can contains multiple collapsed by dimensions, but only a single non-collapsed one'
    }
  }),
  inner_grouping: _configSchema.schema.maybe(_configSchema.schema.arrayOf((0, _shared2.mergeAllBucketsWithChartDimensionSchema)(partitionStateBreakdownByOptionsSchema), {
    minSize: 1,
    meta: {
      description: 'Array of horizontal breakdown dimensions: it can contains multiple collapsed by dimensions, but only a single non-collapsed one'
    }
  }))
}, {
  meta: {
    description: 'Mosaic chart configuration schema for data source queries (non-ES|QL mode), defining metrics and breakdown dimensions'
  },
  validate: validateMosaicGroupings
});
const mosaicStateSchemaESQL = _configSchema.schema.object({
  type: _configSchema.schema.literal('mosaic'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetEsqlTableSchema,
  ...mosaicStateSharedSchema,
  /**
   * Primary value configuration, must define operation. In ES|QL mode, uses column-based configuration.
   */
  metric: _configSchema.schema.allOf([_configSchema.schema.object(_metric_ops.genericOperationOptionsSchema), partitionStatePrimaryMetricOptionsSchema, _metric_ops.esqlColumnSchema], {
    meta: {
      description: 'Metric configuration for ES|QL mode, combining generic options, primary metric options, and column selection'
    }
  }),
  outer_grouping: _configSchema.schema.arrayOf(_configSchema.schema.allOf([partitionStateBreakdownByOptionsSchema, _metric_ops.esqlColumnSchema]), {
    minSize: 1,
    meta: {
      description: 'Array of vertical grouping dimensions: it can contains multiple collapsed by dimensions, but only a single non-collapsed one'
    }
  }),
  inner_grouping: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.allOf([partitionStateBreakdownByOptionsSchema, _metric_ops.esqlColumnSchema]), {
    minSize: 1,
    meta: {
      description: 'Array of vertical grouping dimensions: it can contains multiple collapsed by dimensions, but only a single non-collapsed one'
    }
  }))
}, {
  meta: {
    description: 'Mosaic chart configuration schema for ES|QL queries, defining metrics and breakdown dimensions using column-based configuration'
  },
  validate: validateMosaicGroupings
});
const mosaicStateSchema = exports.mosaicStateSchema = _configSchema.schema.oneOf([mosaicStateSchemaNoESQL, mosaicStateSchemaESQL], {
  meta: {
    description: 'Mosaic chart configuration schema supporting both data source queries (non-ES|QL) and ES|QL query modes'
  }
});