"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DynamicTreeView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _tree_view = require("@elastic/eui/lib/components/tree_view/tree_view.styles");
var _translations = require("../../../../common/translations");
var _hooks = require("./hooks");
var _styles = require("./styles");
var _helpers = require("./helpers");
var _contexts = require("../contexts");
var _tree_view_icon = require("../tree_view_icon");
var _translations2 = require("../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/kubernetes_security/public/components/tree_view_container/dynamic_tree_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error style types not defined, but they exist
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BUTTON_TEST_ID = 'kubernetesSecurity:dynamicTreeViewButton';
const focusNextButton = event => {
  (0, _helpers.focusNextElement)(event, `[data-test-subj="${BUTTON_TEST_ID}"]`, 'next');
};
const focusPreviousButton = event => {
  (0, _helpers.focusNextElement)(event, `[data-test-subj="${BUTTON_TEST_ID}"]`, 'prev');
};
const DynamicTreeViewExpander = ({
  defaultExpanded = false,
  children
}) => {
  const [isExpanded, setIsExpanded] = (0, _react.useState)(defaultExpanded);
  const onToggleExpand = () => {
    setIsExpanded(e => !e);
  };
  return children({
    isExpanded,
    onToggleExpand
  });
};
const DynamicTreeView = ({
  tree,
  depth = 0,
  selectionDepth = {},
  query,
  onSelect,
  selected = '',
  expanded = true,
  onKeyDown
}) => {
  var _data$pages4;
  const styles = (0, _styles.useStyles)(depth);
  const euiStyles = (0, _tree_view.euiTreeViewStyles)((0, _eui.useEuiTheme)());
  const euiTreeViewCss = [euiStyles.euiTreeView, euiStyles.default];
  const {
    indexPattern,
    setNoResults,
    setTreeNavSelection
  } = (0, _contexts.useTreeViewContext)();
  const {
    data,
    fetchNextPage,
    isFetchingNextPage,
    hasNextPage,
    isLoading
  } = (0, _hooks.useFetchDynamicTreeView)(query, tree[depth].key, indexPattern, expanded);
  const onLoadMoreKeydown = event => {
    switch (event.key) {
      case _eui.keys.ARROW_DOWN:
        {
          focusNextButton(event);
          break;
        }
      case _eui.keys.ARROW_UP:
        {
          focusPreviousButton(event);
          break;
        }
      case _eui.keys.ARROW_RIGHT:
        {
          (0, _helpers.disableEventDefaults)(event);
          fetchNextPage();
        }
    }
  };
  (0, _react.useEffect)(() => {
    if (depth === 0 && data) {
      var _data$pages;
      const noData = ((_data$pages = data.pages) === null || _data$pages === void 0 ? void 0 : _data$pages[0].buckets.length) === 0;
      setNoResults(noData);
      if (noData) {
        setTreeNavSelection({});
      }
    }
  }, [data, depth, setNoResults, setTreeNavSelection]);
  (0, _react.useEffect)(() => {
    if (expanded) {
      fetchNextPage();
    }
  }, [fetchNextPage, expanded]);
  (0, _react.useEffect)(() => {
    var _data$pages2, _data$pages2$0$bucket, _data$pages2$0$bucket2;
    if (!selected && !depth && data && (_data$pages2 = data.pages) !== null && _data$pages2 !== void 0 && (_data$pages2$0$bucket = _data$pages2[0].buckets) !== null && _data$pages2$0$bucket !== void 0 && (_data$pages2$0$bucket2 = _data$pages2$0$bucket[0]) !== null && _data$pages2$0$bucket2 !== void 0 && _data$pages2$0$bucket2.key) {
      onSelect({}, tree[depth].type, data.pages[0].buckets[0].key, data.pages[0].buckets[0].key_as_string);
    }
  }, [data, depth, selected, onSelect, tree]);
  const onClickNextPageHandler = () => {
    fetchNextPage();
  };
  const itemList = (0, _react.useMemo)(() => {
    var _data$pages3;
    return (data === null || data === void 0 ? void 0 : (_data$pages3 = data.pages) === null || _data$pages3 === void 0 ? void 0 : _data$pages3.map(aggsData => {
      return aggsData === null || aggsData === void 0 ? void 0 : aggsData.buckets;
    }).flat()) || [];
  }, [data === null || data === void 0 ? void 0 : data.pages]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: styles.euiTreeViewWrapper,
    hidden: !expanded,
    onKeyDown: onKeyDown,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 5
    }
  }, depth === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiI18n, {
    token: "euiTreeView.listNavigationInstructions",
    default: "You can quickly navigate this list using arrow keys.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, listNavigationInstructions => /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    id: "dynamicTreeViewInstructionId",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 15
    }
  }, listNavigationInstructions))), /*#__PURE__*/_react.default.createElement("ul", {
    css: euiTreeViewCss,
    "aria-describedby": data !== null && data !== void 0 && (_data$pages4 = data.pages) !== null && _data$pages4 !== void 0 && _data$pages4.length ? 'dynamicTreeViewInstructionId' : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiTreeView.Item, {
    id: "dynamicTreeViewLoading",
    css: styles.nonInteractiveItem,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 19
      }
    }),
    label: _translations.TREE_NAVIGATION_LOADING,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }), !isLoading && !itemList.length && /*#__PURE__*/_react.default.createElement(_eui.EuiTreeView.Item, {
    id: "dynamicTreeViewEmpty",
    css: styles.nonInteractiveItem,
    label: _translations.TREE_NAVIGATION_EMPTY,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }), itemList.map(aggData => {
    const queryFilter = {
      ...query,
      bool: {
        ...query.bool,
        filter: [...query.bool.filter, {
          term: {
            [tree[depth].key]: aggData.key
          }
        }]
      }
    };
    const defaultExpanded = selected.indexOf('' + aggData.key) > 0;
    return /*#__PURE__*/_react.default.createElement(DynamicTreeViewExpander, {
      key: aggData.key,
      defaultExpanded: defaultExpanded,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 13
      }
    }, ({
      isExpanded,
      onToggleExpand
    }) => /*#__PURE__*/_react.default.createElement(DynamicTreeViewItem, {
      aggData: aggData,
      depth: depth,
      expanded: expanded,
      isExpanded: isExpanded,
      onSelect: onSelect,
      onToggleExpand: onToggleExpand,
      query: queryFilter,
      selected: selected,
      selectionDepth: selectionDepth,
      tree: tree,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 17
      }
    }));
  }), hasNextPage && /*#__PURE__*/_react.default.createElement(_eui.EuiTreeView.Item, {
    id: "dynamicTreeViewLoadMore",
    css: styles.loadMoreButton,
    "aria-label": (0, _translations.TREE_NAVIGATION_SHOW_MORE)(tree[depth].namePlural),
    "data-test-subj": BUTTON_TEST_ID,
    onKeyDown: event => onLoadMoreKeydown(event),
    onClick: onClickNextPageHandler,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      css: styles.loadMoreBadge,
      iconSide: "right",
      iconType: isFetchingNextPage ? _eui.EuiLoadingSpinner : 'arrowDown',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 15
      }
    }, isFetchingNextPage ? _translations.TREE_NAVIGATION_LOADING : (0, _translations.TREE_NAVIGATION_SHOW_MORE)(tree[depth].namePlural)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 11
    }
  })));
};
exports.DynamicTreeView = DynamicTreeView;
const DynamicTreeViewItem = ({
  depth,
  tree,
  onToggleExpand,
  onSelect,
  aggData,
  selectionDepth,
  isExpanded,
  selected,
  expanded,
  query
}) => {
  const isLastNode = depth === tree.length - 1;
  const buttonRef = (0, _react.useRef)({});
  const handleSelect = () => {
    if (tree[depth].type === 'clusterId') {
      onSelect(selectionDepth, tree[depth].type, aggData.key, aggData.key_as_string);
    } else {
      onSelect(selectionDepth, tree[depth].type, aggData.key);
    }
  };
  const onKeyboardToggle = () => {
    if (!isLastNode) {
      onToggleExpand();
    }
    handleSelect();
  };
  const onButtonToggle = () => {
    if (!isLastNode) {
      onToggleExpand();
    }
    handleSelect();
  };

  // Enable keyboard navigation
  const onKeyDown = event => {
    switch (event.key) {
      case _eui.keys.ARROW_DOWN:
        {
          focusNextButton(event);
          break;
        }
      case _eui.keys.ARROW_UP:
        {
          focusPreviousButton(event);
          break;
        }
      case _eui.keys.ARROW_RIGHT:
        {
          if (!isExpanded && !isLastNode) {
            (0, _helpers.disableEventDefaults)(event);
            onKeyboardToggle();
          }
          break;
        }
      case _eui.keys.ARROW_LEFT:
        {
          if (isExpanded) {
            (0, _helpers.disableEventDefaults)(event);
            onKeyboardToggle();
          }
        }
      default:
        break;
    }
  };
  const onChildrenKeydown = (event, key) => {
    if (event.key === _eui.keys.ARROW_LEFT) {
      (0, _helpers.disableEventDefaults)(event);
      buttonRef.current[key].focus();
    }
  };
  const clusterLevel = _translations2.BREADCRUMBS_CLUSTER_TREE_VIEW_LEVELS[tree[depth].type];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTreeView.Item, {
    id: aggData.key_as_string || `${aggData.key}`,
    hasArrow: !isLastNode,
    isExpanded: isExpanded,
    onClick: onButtonToggle,
    onKeyDown: onKeyDown,
    icon: /*#__PURE__*/_react.default.createElement(_tree_view_icon.TreeViewIcon, (0, _extends2.default)({}, tree[depth].iconProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 314,
        columnNumber: 13
      }
    })),
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      anchorClassName: "eui-textTruncate",
      content: `${clusterLevel}: ${aggData.key}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 316,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 317,
        columnNumber: 11
      }
    }, aggData.key_as_string || aggData.key)),
    buttonRef: el => buttonRef.current[aggData.key] = el,
    "data-test-subj": expanded ? BUTTON_TEST_ID : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 5
    }
  }, !isLastNode && /*#__PURE__*/_react.default.createElement(DynamicTreeView, {
    expanded: isExpanded,
    query: query,
    depth: depth + 1,
    selectionDepth: {
      ...selectionDepth,
      [tree[depth].type]: aggData.key,
      ...(tree[depth].type === 'clusterId' && {
        clusterName: aggData.key_as_string
      })
    },
    tree: tree,
    onSelect: onSelect,
    selected: selected,
    onKeyDown: event => onChildrenKeydown(event, aggData.key.toString()),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 9
    }
  }));
};