"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProcessorsState = exports.reducer = void 0;
var _uuid = require("uuid");
var _react = require("react");
var _utils = require("../utils");
var _utils2 = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reducer = (state, action) => {
  if (action.type === 'moveProcessor') {
    const {
      destination,
      source
    } = action.payload;
    try {
      return (0, _utils2.unsafeProcessorMove)(state, source, destination);
    } catch (e) {
      // eslint-disable-next-line no-console
      console.error(e);
      return {
        ...state
      };
    }
  }
  if (action.type === 'removeProcessor') {
    const {
      selector
    } = action.payload;
    const processorsSelector = selector.slice(0, -1);
    const parentProcessorSelector = processorsSelector.slice(0, -1);
    const idx = parseInt(selector[selector.length - 1], 10);
    const processors = (0, _utils.getValue)(processorsSelector, state);
    processors.splice(idx, 1);
    const parentProcessor = (0, _utils.getValue)(parentProcessorSelector, state);
    if (!processors.length && selector.length && !parentProcessor.isRoot) {
      return (0, _utils.setValue)(processorsSelector, state, undefined);
    }
    return (0, _utils.setValue)(processorsSelector, state, [...processors]);
  }
  if (action.type === 'addProcessor') {
    const {
      processor,
      targetSelector
    } = action.payload;
    if (!targetSelector.length) {
      throw new Error('Expected target selector to contain a path, but received an empty array.');
    }
    const targetProcessor = (0, _utils.getValue)(targetSelector, state);
    if (!targetProcessor) {
      throw new Error(`Could not find processor or processors array at ${targetSelector.join('.')}`);
    }
    if (Array.isArray(targetProcessor)) {
      return (0, _utils.setValue)(targetSelector, state, targetProcessor.concat({
        ...processor,
        id: (0, _uuid.v4)()
      }));
    } else {
      const processorWithId = {
        ...processor,
        id: (0, _uuid.v4)()
      };
      targetProcessor.onFailure = targetProcessor.onFailure ? targetProcessor.onFailure.concat(processorWithId) : [processorWithId];
      return (0, _utils.setValue)(targetSelector, state, targetProcessor);
    }
  }
  if (action.type === 'updateProcessor') {
    const {
      processor,
      selector
    } = action.payload;
    const processorsSelector = selector.slice(0, -1);
    const idx = parseInt(selector[selector.length - 1], 10);
    if (isNaN(idx)) {
      throw new Error(`Expected numeric value, received ${idx}`);
    }
    const processors = (0, _utils.getValue)(processorsSelector, state);
    processors[idx] = processor;
    return (0, _utils.setValue)(processorsSelector, state, [...processors]);
  }
  if (action.type === 'duplicateProcessor') {
    const sourceSelector = action.payload.source;
    const sourceProcessor = (0, _utils.getValue)(sourceSelector, state);
    const sourceIdx = parseInt(sourceSelector[sourceSelector.length - 1], 10);
    const sourceProcessorsArraySelector = sourceSelector.slice(0, -1);
    const sourceProcessorsArray = [...(0, _utils.getValue)(sourceProcessorsArraySelector, state)];
    const copy = (0, _utils2.duplicateProcessor)(sourceProcessor);
    sourceProcessorsArray.splice(sourceIdx + 1, 0, copy);
    return (0, _utils.setValue)(sourceProcessorsArraySelector, state, sourceProcessorsArray);
  }
  if (action.type === 'loadProcessors') {
    var _action$payload$newSt;
    return {
      ...action.payload.newState,
      onFailure: (_action$payload$newSt = action.payload.newState.onFailure) !== null && _action$payload$newSt !== void 0 ? _action$payload$newSt : [],
      isRoot: true
    };
  }
  return state;
};
exports.reducer = reducer;
const useProcessorsState = initialState => {
  var _initialState$onFailu;
  const state = {
    ...initialState,
    onFailure: (_initialState$onFailu = initialState.onFailure) !== null && _initialState$onFailu !== void 0 ? _initialState$onFailu : []
  };
  return (0, _react.useReducer)(reducer, {
    ...state,
    isRoot: true
  });
};
exports.useProcessorsState = useProcessorsState;