"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInfraRequestHandlerContext = getInfraRequestHandlerContext;
var _common = require("@kbn/spaces-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getInfraRequestHandlerContext({
  coreContext,
  request,
  plugins
}) {
  var _plugins$ml, _plugins$ml2, _plugins$spaces$space, _plugins$spaces;
  const savedObjectsClient = coreContext.savedObjects.client;
  const uiSettingsClient = coreContext.uiSettings.client;
  const metricsClient = plugins.metricsDataAccess.client;
  const mlSystem = (_plugins$ml = plugins.ml) === null || _plugins$ml === void 0 ? void 0 : _plugins$ml.mlSystemProvider(request, savedObjectsClient);
  const mlAnomalyDetectors = (_plugins$ml2 = plugins.ml) === null || _plugins$ml2 === void 0 ? void 0 : _plugins$ml2.anomalyDetectorsProvider(request, savedObjectsClient);
  const spaceId = (_plugins$spaces$space = (_plugins$spaces = plugins.spaces) === null || _plugins$spaces === void 0 ? void 0 : _plugins$spaces.spacesService.getSpaceId(request)) !== null && _plugins$spaces$space !== void 0 ? _plugins$spaces$space : _common.DEFAULT_SPACE_ID;
  const getMetricsIndices = async () => {
    return metricsClient.getMetricIndices({
      savedObjectsClient
    });
  };
  return {
    mlAnomalyDetectors,
    mlSystem,
    spaceId,
    savedObjectsClient,
    uiSettingsClient,
    getMetricsIndices
  };
}