"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchProfilingFunctions = fetchProfilingFunctions;
var _server = require("@kbn/observability-plugin/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchProfilingFunctions(params, profilingDataAccess, coreRequestContext) {
  const {
    kuery,
    from,
    to,
    startIndex,
    endIndex
  } = params;
  const startSecs = from / 1000;
  const endSecs = to / 1000;
  return await profilingDataAccess.services.fetchFunctions({
    core: coreRequestContext,
    esClient: coreRequestContext.elasticsearch.client.asCurrentUser,
    startIndex,
    endIndex,
    totalSeconds: endSecs - startSecs,
    query: {
      bool: {
        filter: [...(0, _server.kqlQuery)(kuery), {
          range: {
            ['@timestamp']: {
              gte: String(startSecs),
              lt: String(endSecs),
              format: 'epoch_second'
            }
          }
        }]
      }
    }
  });
}