"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initDeleteCustomDashboardRoute = initDeleteCustomDashboardRoute;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _custom_dashboards_api = require("../../../common/http_api/custom_dashboards_api");
var _handle_route_errors = require("../../utils/handle_route_errors");
var _check_custom_dashboards_enabled = require("./lib/check_custom_dashboards_enabled");
var _delete_custom_dashboard = require("./lib/delete_custom_dashboard");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initDeleteCustomDashboardRoute(framework) {
  const validateParams = (0, _ioTsUtils.createRouteValidationFunction)(_custom_dashboards_api.InfraDeleteCustomDashboardsRequestParamsRT);
  framework.registerRoute({
    method: 'delete',
    path: '/api/infra/{assetType}/custom-dashboards/{id}',
    validate: {
      params: validateParams
    },
    options: {
      access: 'internal'
    }
  }, (0, _handle_route_errors.handleRouteErrors)(async (context, request, response) => {
    const {
      savedObjectsClient,
      uiSettingsClient
    } = await context.infra;
    await (0, _check_custom_dashboards_enabled.checkCustomDashboardsEnabled)(uiSettingsClient);
    const {
      id
    } = request.params;
    await (0, _delete_custom_dashboard.deleteCustomDashboard)({
      savedObjectsClient,
      savedObjectId: id
    });
    return response.ok({
      body: id
    });
  }));
}