"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLegend = void 0;
var _get_color_palette = require("./get_color_palette");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createLegend = (name, steps = 10, reverse = false, rules = [], type = 'gradient') => {
  const paletteColors = (0, _get_color_palette.getColorPalette)(name, steps, reverse);
  return type === 'steps' && rules.length > 0 ? {
    type: 'steps',
    rules
  } : {
    type: 'steppedGradient',
    rules: paletteColors.map((color, index) => ({
      color,
      value: (index + 1) / steps
    }))
  };
};
exports.createLegend = createLegend;