"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSnapshot = useSnapshot;
var _react = require("react");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _snapshot_api = require("../../../../../common/http_api/snapshot_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSnapshot(props, {
  sendRequestImmediately = true
} = {}) {
  const payload = (0, _react.useMemo)(() => JSON.stringify(buildPayload(props)), [props]);
  const {
    data,
    status,
    error,
    refetch
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    const response = await callApi('/api/metrics/snapshot', {
      method: 'POST',
      body: payload
    });
    return (0, _ioTsUtils.decodeOrThrow)(_snapshot_api.SnapshotNodeResponseRT)(response);
  }, [payload], {
    autoFetch: sendRequestImmediately
  });
  return {
    error: error && error.message || null,
    loading: (0, _use_fetcher.isPending)(status),
    nodes: (data === null || data === void 0 ? void 0 : data.nodes) || [],
    interval: (data === null || data === void 0 ? void 0 : data.interval) || '60s',
    reload: refetch
  };
}
const buildPayload = args => {
  const {
    accountId = '',
    currentTime,
    dropPartialBuckets = true,
    kuery,
    groupBy = null,
    includeTimeseries,
    metrics,
    nodeType,
    overrideCompositeSize,
    region = '',
    sourceId,
    timerange,
    schema
  } = args;
  return {
    accountId,
    dropPartialBuckets,
    kuery,
    groupBy,
    includeTimeseries,
    metrics,
    nodeType,
    sourceId,
    overrideCompositeSize,
    region,
    schema: schema !== null && schema !== void 0 ? schema : 'ecs',
    timerange: timerange !== null && timerange !== void 0 ? timerange : {
      interval: '1m',
      to: currentTime,
      from: currentTime - 1200 * 1000,
      lookbackSize: 5
    }
  };
};