"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendSteps = LegendSteps;
exports.hasLegendStepsDuplicates = hasLegendStepsDuplicates;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/legend_steps.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ColorCell({
  color,
  onChange
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    onChange: onChange,
    color: color,
    compressed: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiColorPickerSwatch, {
      color: color,
      "aria-label": _i18n.i18n.translate('xpack.infra.legendSteps.selectColorAriaLabel', {
        defaultMessage: 'Select color'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  });
}
const MAX_STEPS = 18;
const MIN_STEPS = 2;
const MAX_CONTAINER_HEIGHT = 500;
function hasLegendStepsDuplicates(steps) {
  const values = steps.map(s => s.value);
  const labels = steps.map(s => s.label.trim()).filter(l => l !== '');
  const hasDuplicateValues = new Set(values).size !== values.length;
  const hasDuplicateLabels = new Set(labels).size !== labels.length;
  return hasDuplicateValues || hasDuplicateLabels;
}
function LegendSteps({
  steps,
  onChange
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const scrollContainerRef = (0, _react.useRef)(null);
  const hasDuplicates = hasLegendStepsDuplicates(steps);
  const hasEmptyLabels = !steps.every(step => {
    var _step$label;
    return (_step$label = step.label) === null || _step$label === void 0 ? void 0 : _step$label.trim();
  });
  const errors = [];
  if (hasDuplicates) {
    errors.push(_i18n.i18n.translate('xpack.infra.legendSteps.duplicateStepsError', {
      defaultMessage: 'Steps cannot have duplicate values or labels'
    }));
  }
  if (hasEmptyLabels) {
    errors.push(_i18n.i18n.translate('xpack.infra.legendSteps.emptyLabelsError', {
      defaultMessage: 'All steps must have a label'
    }));
  }
  const isDuplicateValue = (0, _react.useCallback)((item, value) => {
    return steps.some(s => s !== item && s.value === value);
  }, [steps]);
  const isDuplicateLabel = (0, _react.useCallback)((item, label) => {
    // Only check non-empty labels
    if (!label.trim()) return false;
    return steps.some(s => s !== item && s.label.trim() === label.trim());
  }, [steps]);
  const updateStep = (0, _react.useCallback)((step, updates) => {
    const index = steps.findIndex(s => s === step);
    if (index === -1) return;
    const updatedSteps = [...steps];
    updatedSteps[index] = {
      ...updatedSteps[index],
      ...updates
    };
    onChange(updatedSteps);
  }, [steps, onChange]);
  const handleDeleteStep = (0, _react.useCallback)(step => {
    const updatedSteps = steps.filter(s => s !== step);
    onChange(updatedSteps);
  }, [steps, onChange]);
  const handleAddStep = (0, _react.useCallback)(() => {
    const newStep = {
      color: euiTheme.colors.textSubdued,
      label: '',
      value: 0
    };
    onChange([...steps, newStep]);

    // Scroll to bottom after adding a step
    requestAnimationFrame(() => {
      if (scrollContainerRef.current) {
        scrollContainerRef.current.scrollTop = scrollContainerRef.current.scrollHeight;
      }
    });
  }, [steps, onChange, euiTheme.colors.textSubdued]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'color',
    name: _i18n.i18n.translate('xpack.infra.legendSteps.colorColumnLabel', {
      defaultMessage: 'Color'
    }),
    width: '60px',
    render: (color, item) => /*#__PURE__*/_react.default.createElement(ColorCell, {
      color: color,
      onChange: newColor => updateStep(item, {
        color: newColor
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 11
      }
    })
  }, {
    field: 'label',
    name: _i18n.i18n.translate('xpack.infra.legendSteps.labelColumnLabel', {
      defaultMessage: 'Label'
    }),
    render: (label, item) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      compressed: true,
      fullWidth: false,
      value: label,
      isInvalid: isDuplicateLabel(item, label),
      placeholder: _i18n.i18n.translate('xpack.infra.legendSteps.labelPlaceholder', {
        defaultMessage: 'Label'
      }),
      onChange: e => updateStep(item, {
        label: e.target.value
      }),
      "aria-label": _i18n.i18n.translate('xpack.infra.legendSteps.labelInputAriaLabel', {
        defaultMessage: 'Step label'
      }),
      "data-test-subj": `infraLegendStepsLabelInput-${item.value}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 11
      }
    })
  }, {
    field: 'value',
    name: _i18n.i18n.translate('xpack.infra.legendSteps.valueColumnLabel', {
      defaultMessage: 'Value'
    }),
    width: '80px',
    render: (value, item) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      compressed: true,
      fullWidth: false,
      step: 0.01,
      value: value,
      isInvalid: isDuplicateValue(item, value),
      onChange: e => {
        const parsed = parseFloat(e.target.value);
        updateStep(item, {
          value: isNaN(parsed) ? 0 : parsed
        });
      },
      "aria-label": _i18n.i18n.translate('xpack.infra.legendSteps.valueInputAriaLabel', {
        defaultMessage: 'Step value'
      }),
      "data-test-subj": `infraLegendStepsValueInput-${item.value}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 11
      }
    })
  }, {
    field: 'actions',
    name: '',
    width: '40px',
    render: (_value, item) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.infra.legendSteps.deleteButtonAriaLabel', {
        defaultMessage: 'Delete step'
      }),
      color: "danger",
      iconType: "trash",
      size: "xs",
      onClick: () => handleDeleteStep(item),
      disabled: steps.length <= MIN_STEPS,
      "data-test-subj": "infraLegendStepsDeleteStepButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 11
      }
    })
  }], [updateStep, handleDeleteStep, steps.length, isDuplicateLabel, isDuplicateValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errors.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "alert",
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.infra.legendSteps.validationErrorTitle', {
      defaultMessage: 'Please fix the following errors:'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 13
    }
  }, errors.map((error, index) => /*#__PURE__*/_react.default.createElement("li", {
    key: index,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 17
    }
  }, error)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    ref: scrollContainerRef,
    style: {
      maxHeight: MAX_CONTAINER_HEIGHT,
      overflowY: 'auto'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: steps,
    tableLayout: "auto",
    responsiveBreakpoint: false,
    tableCaption: _i18n.i18n.translate('xpack.infra.legendSteps.tableCaption', {
      defaultMessage: 'Legend steps configuration'
    }),
    rowProps: item => ({
      'data-test-subj': `legendStepRow-${item.value}`
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "text",
    size: "s",
    onClick: handleAddStep,
    iconType: "plus",
    "data-test-subj": "infraLegendStepsAddStepButton",
    disabled: steps.length >= MAX_STEPS,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.infra.legendSteps.addStepButtonLabel', {
    defaultMessage: 'Add step'
  })));
}