"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubtitle = exports.KpiCharts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_reload_request_time = require("../../../../../hooks/use_reload_request_time");
var _asset_details = require("../../../../../components/asset_details");
var _build = require("../../../../../utils/filters/build");
var _use_unified_search = require("../../hooks/use_unified_search");
var _use_hosts_view = require("../../hooks/use_hosts_view");
var _use_host_count = require("../../hooks/use_host_count");
var _use_after_loaded_state = require("../../hooks/use_after_loaded_state");
var _metrics_source = require("../../../../../containers/metrics_source");
var _constants = require("../../../../../components/asset_details/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/components/kpis/kpi_charts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getSubtitle = ({
  formulaValue,
  limit,
  hostCount
}) => {
  // Check if 'max' is the first word/function in the formula
  // Handles: "max(...)", "1 - max(...)", "100 * max(...)", etc.
  if (_constants.MAX_AS_FIRST_FUNCTION_PATTERN.test(formulaValue)) {
    return limit < hostCount ? _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.subtitle.max.limit', {
      defaultMessage: 'Max (of {limit} hosts)',
      values: {
        limit
      }
    }) : _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.subtitle.max', {
      defaultMessage: 'Max'
    });
  }
  if (_constants.AVG_OR_AVERAGE_AS_FIRST_FUNCTION_PATTERN.test(formulaValue)) {
    return limit < hostCount ? _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.subtitle.average.limit', {
      defaultMessage: 'Average (of {limit} hosts)',
      values: {
        limit
      }
    }) : _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.subtitle.average', {
      defaultMessage: 'Average'
    });
  }
  return limit < hostCount ? _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.subtitle.average.limit', {
    defaultMessage: 'of {limit} hosts',
    values: {
      limit
    }
  }) : '';
};
exports.getSubtitle = getSubtitle;
const KpiCharts = () => {
  var _searchCriteria$panel;
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    reloadRequestTime
  } = (0, _use_reload_request_time.useReloadRequestTimeContext)();
  const {
    hostNodes,
    loading: hostsLoading
  } = (0, _use_hosts_view.useHostsViewContext)();
  const {
    loading: hostCountLoading,
    count: hostCount
  } = (0, _use_host_count.useHostCountContext)();
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const shouldUseSearchCriteria = hostNodes.length === 0;
  const loading = hostsLoading || hostCountLoading;
  const filters = shouldUseSearchCriteria ? [...searchCriteria.filters, ...((_searchCriteria$panel = searchCriteria.panelFilters) !== null && _searchCriteria$panel !== void 0 ? _searchCriteria$panel : [])] : [(0, _build.buildCombinedAssetFilter)({
    field: 'host.name',
    values: hostNodes.map(p => p.name),
    dataView: metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference
  })];
  const getSubtitleFn = (0, _react.useMemo)(() => {
    return formulaValue => getSubtitle({
      limit: searchCriteria.limit,
      hostCount,
      formulaValue
    });
  }, [searchCriteria.limit, hostCount]);

  // prevents requests and searchCriteria state from reloading the chart
  // we want it to reload only once the table has finished loading.
  // attributes passed to useAfterLoadedState don't need to be memoized
  const {
    afterLoadedState
  } = (0, _use_after_loaded_state.useAfterLoadedState)(loading, {
    dateRange: searchCriteria.dateRange,
    query: shouldUseSearchCriteria ? searchCriteria.query : undefined,
    filters,
    reloadRequestTime,
    getSubtitle: getSubtitleFn
  });
  return /*#__PURE__*/_react.default.createElement(_asset_details.HostKpiCharts, {
    dataView: metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference,
    dateRange: afterLoadedState.dateRange,
    filters: afterLoadedState.filters,
    query: afterLoadedState.query,
    lastReloadRequestTime: afterLoadedState.reloadRequestTime,
    getSubtitle: afterLoadedState.getSubtitle,
    loading: loading,
    schema: searchCriteria.preferredSchema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  });
};
exports.KpiCharts = KpiCharts;