"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimeRange = void 0;
var _react = require("react");
var _datemath = require("../utils/datemath");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_FROM_IN_MILLISECONDS = 15 * 60000;
const getDefaultTimestamps = () => {
  const now = Date.now();
  return {
    from: new Date(now - DEFAULT_FROM_IN_MILLISECONDS).toISOString(),
    to: new Date(now).toISOString()
  };
};
const useTimeRange = ({
  rangeFrom,
  rangeTo
}) => {
  const parsedDateRange = (0, _react.useMemo)(() => {
    const defaults = getDefaultTimestamps();
    if (!rangeFrom || !rangeTo) {
      return defaults;
    }
    const {
      from = defaults.from,
      to = defaults.to
    } = (0, _datemath.parseDateRange)({
      from: rangeFrom,
      to: rangeTo
    });
    return {
      from,
      to
    };
  }, [rangeFrom, rangeTo]);
  return parsedDateRange;
};
exports.useTimeRange = useTimeRange;