"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSourceNotifier = void 0;
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSourceNotifier = () => {
  const {
    services: {
      notifications
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const updateFailure = message => {
    notifications.toasts.addDanger({
      toastLifeTimeMs: 3000,
      title: _i18n.i18n.translate('xpack.infra.sourceConfiguration.updateFailureTitle', {
        defaultMessage: 'Configuration update failed'
      }),
      text: [_i18n.i18n.translate('xpack.infra.sourceConfiguration.updateFailureBody', {
        defaultMessage: "We couldn't apply the changes to the Metrics configuration. Try again later."
      }), message].filter(Boolean).join(' ')
    });
  };
  const updateSuccess = () => {
    notifications.toasts.addSuccess({
      toastLifeTimeMs: 3000,
      title: _i18n.i18n.translate('xpack.infra.sourceConfiguration.updateSuccessTitle', {
        defaultMessage: 'Metrics settings successfully updated'
      })
    });
  };
  return {
    updateFailure,
    updateSuccess
  };
};
exports.useSourceNotifier = useSourceNotifier;